/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.resources;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.sonar.api.batch.bootstrap.ProjectDefinition;
import org.sonar.api.resources.Language;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Qualifiers;
import org.sonar.api.resources.Resource;

public class QualifiersTest {
    @Test
    public void testRootView() {
        View root = View.createRootView();
        Assert.assertThat((Object)Qualifiers.isView((Resource)root, (boolean)true), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)Qualifiers.isView((Resource)root, (boolean)false), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)Qualifiers.isProject((Resource)root, (boolean)true), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)Qualifiers.isProject((Resource)root, (boolean)false), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testSubView() {
        View subview = View.createSubView();
        Assert.assertThat((Object)Qualifiers.isView((Resource)subview, (boolean)true), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)Qualifiers.isView((Resource)subview, (boolean)false), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)Qualifiers.isProject((Resource)subview, (boolean)true), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)Qualifiers.isProject((Resource)subview, (boolean)false), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testProject() {
        ProjectDefinition rootDef = ProjectDefinition.create();
        ProjectDefinition moduleDef = ProjectDefinition.create();
        rootDef.addSubProject(moduleDef);
        Project root = new Project(rootDef);
        Assert.assertThat((Object)Qualifiers.isView((Resource)root, (boolean)true), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)Qualifiers.isView((Resource)root, (boolean)false), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)Qualifiers.isProject((Resource)root, (boolean)true), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)Qualifiers.isProject((Resource)root, (boolean)false), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testModule() {
        ProjectDefinition rootDef = ProjectDefinition.create();
        ProjectDefinition moduleDef = ProjectDefinition.create();
        rootDef.addSubProject(moduleDef);
        Project sub = new Project(moduleDef);
        Assert.assertThat((Object)Qualifiers.isView((Resource)sub, (boolean)true), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)Qualifiers.isView((Resource)sub, (boolean)false), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)Qualifiers.isProject((Resource)sub, (boolean)true), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)Qualifiers.isProject((Resource)sub, (boolean)false), (Matcher)Matchers.is((Object)false));
    }

    private static class View
    extends Resource {
        private String qualifier;

        private View(String qualifier) {
            this.qualifier = qualifier;
        }

        static View createRootView() {
            return new View("VW");
        }

        static View createSubView() {
            return new View("SVW");
        }

        public String getName() {
            return null;
        }

        public String getLongName() {
            return null;
        }

        public String getDescription() {
            return null;
        }

        public Language getLanguage() {
            return null;
        }

        public String getScope() {
            return "PRJ";
        }

        public String getQualifier() {
            return this.qualifier;
        }

        public Resource getParent() {
            return null;
        }

        public boolean matchFilePattern(String antPattern) {
            return false;
        }
    }
}

