/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.resources;

import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.sonar.api.batch.bootstrap.ProjectDefinition;
import org.sonar.api.resources.Project;

public class ProjectTest {
    @Test
    public void effectiveKeyShouldEqualKeyWithBranch() {
        ProjectDefinition definition = ProjectDefinition.create().setKey("mykey").setProperty("sonar.branch", "branch");
        Assertions.assertThat((String)new Project(definition).getEffectiveKey()).isEqualTo((Object)"mykey:branch");
        Assertions.assertThat((String)new Project(definition).getKey()).isEqualTo((Object)"mykey");
    }

    @Test
    public void setNameWithBranch() {
        ProjectDefinition definition = ProjectDefinition.create().setProperty("sonar.branch", "branch").setKey("key").setName("name");
        Project project = new Project(definition);
        Assertions.assertThat((String)project.getName()).isEqualTo((Object)"name branch");
        Assertions.assertThat((String)project.getOriginalName()).isEqualTo((Object)"name branch");
    }

    @Test
    public void setNameWithoutBranch() {
        ProjectDefinition definition = ProjectDefinition.create().setKey("key").setName("name");
        Project project = new Project(definition);
        Assertions.assertThat((String)project.getName()).isEqualTo((Object)"name");
        Assertions.assertThat((String)project.getOriginalName()).isEqualTo((Object)"name");
    }
}

