/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.resources;

import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.mockito.Mockito;
import org.sonar.api.resources.Language;
import org.sonar.api.resources.Languages;

public class LanguagesTest {
    @Test
    public void should_add_several_times_the_same_language() {
        Languages languages = new Languages(new Language[]{LanguagesTest.language("fake", new String[0]), LanguagesTest.language("fake", new String[0])});
        Assertions.assertThat((String)languages.get("fake").getKey()).isEqualTo((Object)"fake");
    }

    @Test
    public void should_get_suffixes() {
        Languages languages = new Languages(new Language[]{LanguagesTest.language("java", "java"), LanguagesTest.language("php", "php4", "php5")});
        Assertions.assertThat((Object[])languages.getSuffixes(new String[0])).containsOnly((Object[])new String[]{"java", "php4", "php5"});
        Assertions.assertThat((Object[])languages.getSuffixes(new String[]{"java"})).containsOnly((Object[])new String[]{"java"});
        Assertions.assertThat((Object[])languages.getSuffixes(new String[]{"php"})).containsOnly((Object[])new String[]{"php4", "php5"});
        Assertions.assertThat((Object[])languages.getSuffixes(new String[]{"xxx"})).isEmpty();
    }

    @Test
    public void test_no_languages() {
        Languages languages = new Languages();
        Assertions.assertThat((Object)languages.get("foo")).isNull();
        Assertions.assertThat((Object[])languages.getSuffixes(new String[]{"foo"})).isEmpty();
    }

    static Language language(String key, String ... suffixes) {
        Language lang = (Language)Mockito.mock(Language.class);
        Mockito.when((Object)lang.getKey()).thenReturn((Object)key);
        Mockito.when((Object)lang.getFileSuffixes()).thenReturn((Object)suffixes);
        return lang;
    }
}

