/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.resources;

import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.sonar.api.resources.AbstractLanguage;
import org.sonar.api.resources.File;
import org.sonar.api.resources.Language;
import org.sonar.api.resources.Resource;
import org.sonar.api.resources.ResourceUtils;

public class FileTest {
    @Test
    public void trimKeyAndName() {
        File file = File.create((String)"   foo/bar/toto.sql  ");
        Assertions.assertThat((String)file.getKey()).isEqualTo((Object)"foo/bar/toto.sql");
        Assertions.assertThat((String)file.getName()).isEqualTo((Object)"toto.sql");
    }

    @Test
    public void parentIsDirectory() {
        File file = File.create((String)"src/foo/bar/toto.sql", null, (boolean)false);
        Assertions.assertThat((String)file.getKey()).isEqualTo((Object)"src/foo/bar/toto.sql");
        Assertions.assertThat((String)file.getLongName()).isEqualTo((Object)"src/foo/bar/toto.sql");
        Assertions.assertThat((String)file.getName()).isEqualTo((Object)"toto.sql");
        Assertions.assertThat((String)file.getParent().getKey()).isEqualTo((Object)"src/foo/bar");
        Assertions.assertThat((boolean)ResourceUtils.isSpace((Resource)file.getParent())).isEqualTo(true);
    }

    @Test
    public void rootFilesHaveParent() {
        File file = File.create((String)"toto.sql", null, (boolean)false);
        Assertions.assertThat((String)file.getKey()).isEqualTo((Object)"toto.sql");
        Assertions.assertThat((String)file.getName()).isEqualTo((Object)"toto.sql");
        Assertions.assertThat((String)file.getParent().getKey()).isEqualTo((Object)"/");
    }

    @Test
    public void setLanguage() {
        AbstractLanguage lang = new AbstractLanguage("java", "Java"){

            public String[] getFileSuffixes() {
                return null;
            }
        };
        File file = File.create((String)"Foo.java", (Language)lang, (boolean)false);
        Assertions.assertThat((Object)file.getLanguage()).isEqualTo((Object)lang);
        file = File.create((String)"org/sonar/Foo.java", (Language)lang, (boolean)false);
        Assertions.assertThat((Object)file.getLanguage()).isEqualTo((Object)lang);
        Assertions.assertThat((String)file.language()).isEqualTo((Object)"java");
        Assertions.assertThat((Object)file.getParent().getLanguage()).isNull();
    }

    @Test
    public void matchAntPatterns() {
        File file = File.create((String)"src/one/two/foo.sql", null, (boolean)false);
        Assertions.assertThat((boolean)file.matchFilePattern("/src/one/two/*.java")).isFalse();
        Assertions.assertThat((boolean)file.matchFilePattern("false")).isFalse();
        Assertions.assertThat((boolean)file.matchFilePattern("two/one/**")).isFalse();
        Assertions.assertThat((boolean)file.matchFilePattern("other*/**")).isFalse();
        Assertions.assertThat((boolean)file.matchFilePattern("/src/one*/**/*.sql")).isTrue();
        Assertions.assertThat((boolean)file.matchFilePattern("/src/one/t?o/**/*")).isTrue();
        Assertions.assertThat((boolean)file.matchFilePattern("**/*")).isTrue();
        Assertions.assertThat((boolean)file.matchFilePattern("src/one/two/*")).isTrue();
        Assertions.assertThat((boolean)file.matchFilePattern("/src/one/two/*")).isTrue();
        Assertions.assertThat((boolean)file.matchFilePattern("src/**")).isTrue();
    }
}

