/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.resources;

import java.io.File;
import java.io.IOException;
import org.assertj.core.api.Assertions;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mockito.Mockito;
import org.sonar.api.resources.Directory;
import org.sonar.api.resources.Project;

public class DirectoryTest {
    @Rule
    public TemporaryFolder temp = new TemporaryFolder();

    @Test
    public void createFromIoFileShouldComputeCorrectKey() throws IOException {
        File baseDir = this.temp.newFolder();
        Project project = (Project)Mockito.mock(Project.class);
        Mockito.when((Object)project.getBaseDir()).thenReturn((Object)baseDir);
        Directory dir = Directory.fromIOFile((File)new File(baseDir, "src/foo/bar/"), (Project)project);
        Assertions.assertThat((String)dir.getKey()).isEqualTo((Object)"src/foo/bar");
    }

    @Test
    public void shouldNotStartBySlashAndNotEndBySlash() {
        Directory dir = Directory.create((String)"src/foo/bar/");
        Assertions.assertThat((String)dir.getKey()).isEqualTo((Object)"src/foo/bar");
        Assertions.assertThat((String)dir.getName()).isEqualTo((Object)"src/foo/bar");
    }

    @Test
    public void backSlashesShouldBeReplacedBySlashes() {
        Directory dir = Directory.create((String)"  foo\\bar\\     ");
        Assertions.assertThat((String)dir.getKey()).isEqualTo((Object)"foo/bar");
    }

    @Test
    public void directoryHasNoParents() {
        Directory dir = Directory.create((String)"foo/bar");
        Assertions.assertThat((Object)dir.getParent()).isNull();
    }

    @Test
    public void shouldHaveOnlyOneLevelOfDirectory() {
        Assertions.assertThat((Object)Directory.create((String)"one/two/third").getParent()).isNull();
        Assertions.assertThat((Object)Directory.create((String)"one").getParent()).isNull();
    }

    @Test
    public void parseDirectoryKey() {
        Assertions.assertThat((String)Directory.parseKey((String)"/foo/bar")).isEqualTo((Object)"foo/bar");
    }

    @Test
    public void matchExclusionPatterns() {
        Directory directory = Directory.create((String)"src/one/two/third");
        Assertions.assertThat((boolean)directory.matchFilePattern("one/two/*.java")).isFalse();
        Assertions.assertThat((boolean)directory.matchFilePattern("false")).isFalse();
        Assertions.assertThat((boolean)directory.matchFilePattern("two/one/**")).isFalse();
        Assertions.assertThat((boolean)directory.matchFilePattern("other*/**")).isFalse();
        Assertions.assertThat((boolean)directory.matchFilePattern("src/one*/**")).isTrue();
        Assertions.assertThat((boolean)directory.matchFilePattern("src/one/t?o/**")).isTrue();
        Assertions.assertThat((boolean)directory.matchFilePattern("**/*")).isTrue();
        Assertions.assertThat((boolean)directory.matchFilePattern("**")).isTrue();
        Assertions.assertThat((boolean)directory.matchFilePattern("src/one/two/*")).isTrue();
        Assertions.assertThat((boolean)directory.matchFilePattern("/src/one/two/*")).isTrue();
        Assertions.assertThat((boolean)directory.matchFilePattern("src/one/**")).isTrue();
    }
}

