/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.resources;

import java.util.List;
import java.util.NoSuchElementException;
import org.assertj.core.api.Assertions;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.Metric;

public class CoreMetricsTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void read_metrics_from_class_reflection() {
        List metrics = CoreMetrics.getMetrics();
        Assertions.assertThat((int)metrics.size()).isGreaterThan(100);
        Assertions.assertThat((List)metrics).contains((Object[])new Metric[]{CoreMetrics.NCLOC, CoreMetrics.DIRECTORIES});
    }

    @Test
    public void get_metric_by_key() throws Exception {
        Metric metric = CoreMetrics.getMetric((String)"ncloc");
        Assertions.assertThat((String)metric.getKey()).isEqualTo((Object)"ncloc");
    }

    @Test
    public void fail_get_unknown_metric_by_key() throws Exception {
        this.expectedException.expect(NoSuchElementException.class);
        CoreMetrics.getMetric((String)"unknown");
    }
}

