/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.resources;

import org.assertj.core.api.Assertions;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.sonar.api.resources.AbstractLanguage;
import org.sonar.api.resources.Language;

public class AbstractLanguageTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void test_equals_and_hashcode() {
        final Language1 lang1 = new Language1();
        Assertions.assertThat((boolean)lang1.equals((Object)lang1)).isTrue();
        Assertions.assertThat((boolean)lang1.equals((Object)new Language2())).isFalse();
        Assertions.assertThat((boolean)lang1.equals((Object)new Language1Too())).isTrue();
        Assertions.assertThat((boolean)lang1.equals("not a language")).isFalse();
        Assertions.assertThat((boolean)lang1.equals(null)).isFalse();
        Assertions.assertThat((boolean)lang1.equals(new Language(){

            public String getKey() {
                return lang1.getKey();
            }

            public String getName() {
                return lang1.getName();
            }

            public String[] getFileSuffixes() {
                return lang1.getFileSuffixes();
            }
        })).isTrue();
        Assertions.assertThat((int)lang1.hashCode()).isEqualTo(lang1.hashCode());
        Assertions.assertThat((int)lang1.hashCode()).isEqualTo(new Language1Too().hashCode());
    }

    @Test
    public void should_not_define_language_with_too_long_key() {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("The following language key exceeds 20 characters: 'aKeyWhichIsVeryVeryVeryVeryVeryLong'");
        new TooLongKeyLanguage();
    }

    static class Language2
    extends AbstractLanguage {
        public Language2() {
            super("lang2");
        }

        public String[] getFileSuffixes() {
            return new String[0];
        }
    }

    static class Language1Too
    extends AbstractLanguage {
        public Language1Too() {
            super("lang1");
        }

        public String[] getFileSuffixes() {
            return new String[0];
        }
    }

    static class Language1
    extends AbstractLanguage {
        public Language1() {
            super("lang1");
        }

        public String[] getFileSuffixes() {
            return new String[0];
        }
    }

    class TooLongKeyLanguage
    extends AbstractLanguage {
        public TooLongKeyLanguage() {
            super("aKeyWhichIsVeryVeryVeryVeryVeryLong");
        }

        public String[] getFileSuffixes() {
            return null;
        }
    }
}

