/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.profiles;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.commons.io.IOUtils;
import org.custommonkey.xmlunit.Diff;
import org.custommonkey.xmlunit.XMLUnit;
import org.junit.Assert;
import org.junit.Test;
import org.sonar.api.profiles.RulesProfile;
import org.sonar.api.profiles.XMLProfileSerializer;
import org.sonar.api.rules.ActiveRule;
import org.sonar.api.rules.Rule;
import org.sonar.api.rules.RulePriority;
import org.xml.sax.SAXException;

public class XMLProfileSerializerTest {
    @Test
    public void exportEmptyProfile() throws IOException, SAXException {
        StringWriter writer = new StringWriter();
        RulesProfile profile = RulesProfile.create((String)"sonar way", (String)"java");
        new XMLProfileSerializer().write(profile, (Writer)writer);
        XMLProfileSerializerTest.assertSimilarXml("exportEmptyProfile.xml", ((Object)writer).toString());
    }

    @Test
    public void exportProfile() throws IOException, SAXException {
        StringWriter writer = new StringWriter();
        RulesProfile profile = RulesProfile.create((String)"sonar way", (String)"java");
        profile.activateRule(Rule.create((String)"checkstyle", (String)"IllegalRegexp", (String)"illegal regexp"), RulePriority.BLOCKER);
        new XMLProfileSerializer().write(profile, (Writer)writer);
        XMLProfileSerializerTest.assertSimilarXml("exportProfile.xml", ((Object)writer).toString());
    }

    @Test
    public void exportRuleParameters() throws IOException, SAXException {
        StringWriter writer = new StringWriter();
        RulesProfile profile = RulesProfile.create((String)"sonar way", (String)"java");
        Rule rule = Rule.create((String)"checkstyle", (String)"IllegalRegexp", (String)"illegal regexp");
        rule.createParameter("format");
        rule.createParameter("message");
        rule.createParameter("tokens");
        ActiveRule activeRule = profile.activateRule(rule, RulePriority.BLOCKER);
        activeRule.setParameter("format", "foo");
        activeRule.setParameter("message", "with special characters < > &");
        new XMLProfileSerializer().write(profile, (Writer)writer);
        XMLProfileSerializerTest.assertSimilarXml("exportRuleParameters.xml", ((Object)writer).toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void assertSimilarXml(String fileWithExpectedXml, String xml) throws IOException, SAXException {
        String pathToExpectedXml = "/org/sonar/api/profiles/XMLProfileSerializerTest/" + fileWithExpectedXml;
        InputStream stream = XMLProfileSerializerTest.class.getResourceAsStream(pathToExpectedXml);
        try {
            Diff diff = XMLProfileSerializerTest.isSimilarXml(IOUtils.toString((InputStream)stream), xml);
            String message = "Diff: " + diff.toString() + '\n' + "XML: " + xml;
            Assert.assertTrue((String)message, (boolean)diff.similar());
        }
        finally {
            IOUtils.closeQuietly((InputStream)stream);
        }
    }

    static Diff isSimilarXml(String expectedXml, String xml) throws IOException, SAXException {
        XMLUnit.setIgnoreWhitespace((boolean)true);
        Diff diff = XMLUnit.compareXML((String)xml, (String)expectedXml);
        return diff;
    }
}

