/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.profiles;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.sonar.api.profiles.RulesProfile;
import org.sonar.api.profiles.XMLProfileParser;
import org.sonar.api.rules.ActiveRule;
import org.sonar.api.rules.Rule;
import org.sonar.api.rules.RuleFinder;
import org.sonar.api.rules.RulePriority;
import org.sonar.api.utils.ValidationMessages;

public class XMLProfileParserTest {
    @Test
    public void importProfile() {
        ValidationMessages validation = ValidationMessages.create();
        RulesProfile profile = this.parse("importProfile.xml", validation);
        Assertions.assertThat((String)profile.getLanguage()).isEqualTo((Object)"java");
        Assertions.assertThat((String)profile.getName()).isEqualTo((Object)"sonar way");
        Assertions.assertThat((boolean)validation.hasErrors()).isFalse();
        Assertions.assertThat((Object)profile).isNotNull();
        Assertions.assertThat((Comparable)profile.getActiveRule("checkstyle", "IllegalRegexp").getSeverity()).isEqualTo((Object)RulePriority.CRITICAL);
    }

    @Test
    public void nameAndLanguageShouldBeMandatory() {
        ValidationMessages validation = ValidationMessages.create();
        this.parse("nameAndLanguageShouldBeMandatory.xml", validation);
        Assertions.assertThat((List)validation.getErrors()).hasSize(2);
        Assertions.assertThat((String)((String)validation.getErrors().get(0))).contains(new CharSequence[]{""});
    }

    @Test
    public void importProfileWithRuleParameters() {
        ValidationMessages validation = ValidationMessages.create();
        RulesProfile profile = this.parse("importProfileWithRuleParameters.xml", validation);
        Assertions.assertThat((boolean)validation.hasErrors()).isFalse();
        Assertions.assertThat((boolean)validation.hasWarnings()).isFalse();
        ActiveRule rule = profile.getActiveRule("checkstyle", "IllegalRegexp");
        Assertions.assertThat((String)rule.getParameter("format")).isEqualTo((Object)"foo");
        Assertions.assertThat((String)rule.getParameter("message")).isEqualTo((Object)"with special characters < > &");
    }

    @Test
    public void importProfileWithUnknownRuleParameter() {
        ValidationMessages validation = ValidationMessages.create();
        RulesProfile profile = this.parse("importProfileWithUnknownRuleParameter.xml", validation);
        Assertions.assertThat((List)validation.getWarnings()).hasSize(1);
        ActiveRule rule = profile.getActiveRule("checkstyle", "IllegalRegexp");
        Assertions.assertThat((String)rule.getParameter("unknown")).isNull();
    }

    private RulesProfile parse(String resource, ValidationMessages validation) {
        return new XMLProfileParser(this.newRuleFinder()).parseResource(this.getClass().getClassLoader(), this.getResourcePath(resource), validation);
    }

    private String getResourcePath(String resource) {
        return "org/sonar/api/profiles/XMLProfileParserTest/" + resource;
    }

    private RuleFinder newRuleFinder() {
        RuleFinder ruleFinder = (RuleFinder)Mockito.mock(RuleFinder.class);
        Mockito.when((Object)ruleFinder.findByKey(Matchers.anyString(), Matchers.anyString())).thenAnswer((Answer)new Answer<Rule>(){

            public Rule answer(InvocationOnMock iom) throws Throwable {
                Rule rule = Rule.create((String)((String)iom.getArguments()[0]), (String)((String)iom.getArguments()[1]), (String)((String)iom.getArguments()[1]));
                rule.createParameter("format");
                rule.createParameter("message");
                return rule;
            }
        });
        return ruleFinder;
    }
}

