/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.profiles;

import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;
import org.sonar.api.profiles.RulesProfile;
import org.sonar.api.rules.Rule;
import org.sonar.api.rules.RulePriority;
import org.sonar.api.utils.MessageException;

public class RulesProfileTest {
    @Test
    public void searchRulesByConfigKey() {
        RulesProfile profile = RulesProfile.create();
        profile.activateRule(Rule.create((String)"repo", (String)"key1", (String)"name1"), null);
        profile.activateRule(Rule.create((String)"repo", (String)"key2", (String)"name2").setConfigKey("config2"), null);
        Assertions.assertThat((Object)profile.getActiveRuleByConfigKey("repo", "unknown")).isNull();
        Assertions.assertThat((String)profile.getActiveRuleByConfigKey("repo", "config2").getRuleKey()).isEqualTo((Object)"key2");
    }

    @Test
    public void activateRuleWithDefaultPriority() {
        RulesProfile profile = RulesProfile.create();
        Rule rule = Rule.create((String)"repo", (String)"key1", (String)"name1").setSeverity(RulePriority.CRITICAL);
        profile.activateRule(rule, null);
        Assertions.assertThat((Comparable)profile.getActiveRule("repo", "key1").getSeverity()).isEqualTo((Object)RulePriority.CRITICAL);
    }

    @Test
    public void activateRuleWithSpecificPriority() {
        RulesProfile profile = RulesProfile.create();
        Rule rule = Rule.create((String)"repo", (String)"key1", (String)"name1").setSeverity(RulePriority.CRITICAL);
        profile.activateRule(rule, RulePriority.MINOR);
        Assertions.assertThat((Comparable)profile.getActiveRule("repo", "key1").getSeverity()).isEqualTo((Object)RulePriority.MINOR);
    }

    @Test
    public void fail_to_activate_already_activated_rule() {
        RulesProfile profile = RulesProfile.create((String)"Default", (String)"java");
        Rule rule = Rule.create((String)"repo", (String)"key1", (String)"name1").setSeverity(RulePriority.CRITICAL);
        profile.activateRule(rule, null);
        try {
            profile.activateRule(rule, null);
            Assert.fail();
        }
        catch (Exception e) {
            ((AbstractThrowableAssert)Assertions.assertThat((Throwable)e).isInstanceOf(MessageException.class)).hasMessage("The definition of the profile 'Default' (language 'java') contains multiple occurrences of the 'repo:key1' rule. The plugin which declares this profile should fix this.");
        }
    }
}

