/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.profiles;

import com.google.common.collect.Lists;
import java.util.Collection;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.sonar.api.profiles.AnnotationProfileParser;
import org.sonar.api.profiles.FakeRule;
import org.sonar.api.profiles.RuleOnOtherProfile;
import org.sonar.api.profiles.RulesProfile;
import org.sonar.api.rules.Rule;
import org.sonar.api.rules.RuleFinder;
import org.sonar.api.rules.RulePriority;
import org.sonar.api.utils.ValidationMessages;

public class AnnotationProfileParserTest {
    @Test
    public void shouldParseAnnotatedClasses() {
        RuleFinder ruleFinder = (RuleFinder)Mockito.mock(RuleFinder.class);
        Mockito.when((Object)ruleFinder.findByKey(Matchers.anyString(), Matchers.anyString())).thenAnswer((Answer)new Answer<Rule>(){

            public Rule answer(InvocationOnMock iom) throws Throwable {
                return Rule.create((String)((String)iom.getArguments()[0]), (String)((String)iom.getArguments()[1]), (String)((String)iom.getArguments()[1]));
            }
        });
        ValidationMessages messages = ValidationMessages.create();
        RulesProfile profile = new AnnotationProfileParser(ruleFinder).parse("squid", "Foo way", "java", (Collection)Lists.newArrayList((Object[])new Class[]{FakeRule.class}), messages);
        Assert.assertThat((Object)profile.getName(), (Matcher)org.hamcrest.Matchers.is((Object)"Foo way"));
        Assert.assertThat((Object)profile.getLanguage(), (Matcher)org.hamcrest.Matchers.is((Object)"java"));
        Assert.assertThat((Object)profile.getActiveRule("squid", "fake").getSeverity(), (Matcher)org.hamcrest.Matchers.is((Object)RulePriority.BLOCKER));
        Assert.assertThat((Object)messages.hasErrors(), (Matcher)org.hamcrest.Matchers.is((Object)false));
    }

    @Test
    public void shouldParseOnlyWantedProfile() {
        RuleFinder ruleFinder = (RuleFinder)Mockito.mock(RuleFinder.class);
        Mockito.when((Object)ruleFinder.findByKey(Matchers.anyString(), Matchers.anyString())).thenAnswer((Answer)new Answer<Rule>(){

            public Rule answer(InvocationOnMock iom) throws Throwable {
                return Rule.create((String)((String)iom.getArguments()[0]), (String)((String)iom.getArguments()[1]), (String)((String)iom.getArguments()[1]));
            }
        });
        ValidationMessages messages = ValidationMessages.create();
        RulesProfile profile = new AnnotationProfileParser(ruleFinder).parse("squid", "Foo way", "java", (Collection)Lists.newArrayList((Object[])new Class[]{FakeRule.class, RuleOnOtherProfile.class}), messages);
        Assert.assertNotNull((Object)profile.getActiveRule("squid", "fake"));
        Assert.assertNull((Object)profile.getActiveRule("squid", "other"));
    }
}

