/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.measures;

import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.mockito.Mockito;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.Measure;
import org.sonar.api.measures.RangeDistributionBuilder;

public class RangeDistributionBuilderTest {
    @Test
    public void workOnAnLimitsArrayCopy() {
        Number[] limits = new Integer[]{4, 2, 0};
        RangeDistributionBuilder builder = new RangeDistributionBuilder(CoreMetrics.CLASS_COMPLEXITY_DISTRIBUTION, limits);
        builder.add((Number)3.2).add((Number)2.0).add((Number)6.2).build();
        Assertions.assertThat((Object[])builder.getBottomLimits()).isNotSameAs((Object)limits);
        Assertions.assertThat((Integer)limits[0]).isEqualTo(4);
        Assertions.assertThat((Integer)limits[1]).isEqualTo(2);
        Assertions.assertThat((Integer)limits[2]).isEqualTo(0);
    }

    @Test
    public void buildIntegerDistribution() {
        RangeDistributionBuilder builder = new RangeDistributionBuilder(CoreMetrics.CLASS_COMPLEXITY_DISTRIBUTION, (Number[])new Integer[]{0, 2, 4});
        Measure measure = builder.add((Number)3.2).add((Number)2.0).add((Number)6.2).build();
        Assertions.assertThat((String)measure.getData()).isEqualTo((Object)"0=0;2=2;4=1");
    }

    @Test
    public void buildDoubleDistribution() {
        RangeDistributionBuilder builder = new RangeDistributionBuilder(CoreMetrics.CLASS_COMPLEXITY_DISTRIBUTION, (Number[])new Double[]{0.0, 2.0, 4.0});
        Measure measure = builder.add((Number)3.2).add((Number)2.0).add((Number)6.2).build();
        Assertions.assertThat((String)measure.getData()).isEqualTo((Object)"0=0;2=2;4=1");
    }

    @Test
    public void valueLesserThanMinimumIsIgnored() {
        RangeDistributionBuilder builder = new RangeDistributionBuilder(CoreMetrics.CLASS_COMPLEXITY_DISTRIBUTION, (Number[])new Integer[]{0, 2, 4});
        Measure measure = builder.add((Number)3.2).add((Number)2.0).add((Number)-3.0).build();
        Assertions.assertThat((String)measure.getData()).isEqualTo((Object)"0=0;2=2;4=0");
    }

    @Test
    public void addDistributionMeasureWithIdenticalLimits() {
        Measure measureToAdd = (Measure)Mockito.mock(Measure.class);
        Mockito.when((Object)measureToAdd.getData()).thenReturn((Object)"0=3;2=5");
        RangeDistributionBuilder builder = new RangeDistributionBuilder(CoreMetrics.CLASS_COMPLEXITY_DISTRIBUTION, (Number[])new Integer[]{0, 2});
        builder.clear();
        Measure measure = builder.add((Number)1).add(measureToAdd).build();
        Assertions.assertThat((String)measure.getData()).isEqualTo((Object)"0=4;2=5");
    }

    @Test
    public void addDistributionMeasureWithDifferentIntLimits() {
        Measure measureToAdd = (Measure)Mockito.mock(Measure.class);
        Mockito.when((Object)measureToAdd.getData()).thenReturn((Object)"0=3;2=5");
        RangeDistributionBuilder builder = new RangeDistributionBuilder(CoreMetrics.CLASS_COMPLEXITY_DISTRIBUTION, (Number[])new Integer[]{0, 2, 4});
        builder.clear();
        Measure measure = builder.add((Number)1).add(measureToAdd).build();
        Assertions.assertThat((Object)measure).isNull();
    }

    @Test
    public void addDistributionMeasureWithDifferentDoubleLimits() {
        Measure measureToAdd = (Measure)Mockito.mock(Measure.class);
        Mockito.when((Object)measureToAdd.getData()).thenReturn((Object)"0.0=3;3.0=5;6.0=9");
        RangeDistributionBuilder builder = new RangeDistributionBuilder(CoreMetrics.CLASS_COMPLEXITY_DISTRIBUTION, (Number[])new Double[]{0.0, 2.0, 4.0});
        builder.clear();
        Measure measure = builder.add(measureToAdd).build();
        Assertions.assertThat((Object)measure).isNull();
    }

    @Test
    public void initLimitsAtTheFirstAdd() {
        Measure m1 = (Measure)Mockito.mock(Measure.class);
        Mockito.when((Object)m1.getData()).thenReturn((Object)"0.5=3;3.5=5;6.5=9");
        Measure m2 = (Measure)Mockito.mock(Measure.class);
        Mockito.when((Object)m2.getData()).thenReturn((Object)"0.5=0;3.5=2;6.5=1");
        RangeDistributionBuilder builder = new RangeDistributionBuilder(CoreMetrics.CLASS_COMPLEXITY_DISTRIBUTION);
        builder.clear();
        Measure measure = builder.add(m1).add(m2).build();
        Assertions.assertThat((String)measure.getData()).isEqualTo((Object)"0.5=3;3.5=7;6.5=10");
    }

    @Test
    public void keepIntRangesWhenMergingDistributions() {
        Measure m1 = (Measure)Mockito.mock(Measure.class);
        Mockito.when((Object)m1.getData()).thenReturn((Object)"0=3;3=5;6=9");
        Measure m2 = (Measure)Mockito.mock(Measure.class);
        Mockito.when((Object)m2.getData()).thenReturn((Object)"0=0;3=2;6=1");
        RangeDistributionBuilder builder = new RangeDistributionBuilder(CoreMetrics.CLASS_COMPLEXITY_DISTRIBUTION);
        builder.clear();
        Measure measure = builder.add(m1).add(m2).build();
        Assertions.assertThat((String)measure.getData()).isEqualTo((Object)"0=3;3=7;6=10");
    }

    @Test
    public void nullIfEmptyData() {
        RangeDistributionBuilder builder = new RangeDistributionBuilder(CoreMetrics.CLASS_COMPLEXITY_DISTRIBUTION, (Number[])new Integer[]{0, 2, 4});
        Assertions.assertThat((boolean)builder.isEmpty()).isTrue();
        Measure measure = builder.build(false);
        Assertions.assertThat((Object)measure).isNull();
        measure = builder.build(true);
        Assertions.assertThat((String)measure.getData()).isEqualTo((Object)"0=0;2=0;4=0");
    }

    @Test
    public void aggregateEmptyDistribution() {
        RangeDistributionBuilder builder = new RangeDistributionBuilder(CoreMetrics.CLASS_COMPLEXITY_DISTRIBUTION);
        builder.add(new Measure(CoreMetrics.CLASS_COMPLEXITY_DISTRIBUTION, (String)null));
        Measure distribution = builder.build();
        Assertions.assertThat((String)distribution.getData()).isEmpty();
    }
}

