/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.measures;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.Measure;
import org.sonar.api.measures.PropertiesBuilder;

public class PropertiesBuilderTest {
    @Test
    public void buildMeasure() {
        PropertiesBuilder builder = new PropertiesBuilder(CoreMetrics.CLASS_COMPLEXITY_DISTRIBUTION);
        Measure measure = builder.add((Object)1, (Object)30).add((Object)2, (Object)27).add((Object)4, (Object)50).build();
        Assert.assertNotNull((Object)measure);
        Assert.assertThat((Object)measure.getData(), (Matcher)Matchers.is((Object)"1=30;2=27;4=50"));
    }

    @Test
    public void sortKeys() {
        PropertiesBuilder builder = new PropertiesBuilder(CoreMetrics.CLASS_COMPLEXITY_DISTRIBUTION);
        Measure measure = builder.add((Object)"foo", (Object)"fooooo").add((Object)"bar", (Object)"baaaaar").add((Object)"hello", (Object)"world").build();
        Assert.assertNotNull((Object)measure);
        Assert.assertThat((Object)measure.getData(), (Matcher)Matchers.is((Object)"bar=baaaaar;foo=fooooo;hello=world"));
    }

    @Test
    public void valueIsOptional() {
        PropertiesBuilder builder = new PropertiesBuilder(CoreMetrics.CLASS_COMPLEXITY_DISTRIBUTION);
        Measure measure = builder.add((Object)"foo", null).add((Object)"bar", (Object)"bar").add((Object)"hello", (Object)"world").build();
        Assert.assertNotNull((Object)measure);
        Assert.assertThat((Object)measure.getData(), (Matcher)Matchers.is((Object)"bar=bar;foo=;hello=world"));
    }

    @Test
    public void clearBeforeBuildingOtherMeasure() {
        PropertiesBuilder builder = new PropertiesBuilder(CoreMetrics.CLASS_COMPLEXITY_DISTRIBUTION);
        builder.add((Object)"foo", (Object)"foo").add((Object)"bar", (Object)"bar").add((Object)"hello", (Object)"world").build();
        builder.clear();
        Measure measure = builder.add((Object)"1", (Object)"1").add((Object)"2", (Object)"2").add((Object)"foo", (Object)"other").build();
        Assert.assertNotNull((Object)measure);
        Assert.assertThat((Object)measure.getData(), (Matcher)Matchers.is((Object)"1=1;2=2;foo=other"));
    }
}

