/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.measures;

import org.assertj.core.api.Assertions;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.sonar.api.measures.Metric;

public class MetricTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void shouldCreateMetric() {
        Metric metric = new Metric.Builder("foo", "Foo", Metric.ValueType.INT).setDomain("my domain").create();
        Assertions.assertThat((String)metric.getKey()).isEqualTo((Object)"foo");
        Assertions.assertThat((String)metric.getName()).isEqualTo((Object)"Foo");
        Assertions.assertThat((String)metric.getDomain()).isEqualTo((Object)"my domain");
    }

    @Test
    public void shouldCreateMetricWithDefaultValues() {
        Metric metric = new Metric.Builder("foo", "Foo", Metric.ValueType.INT).create();
        Assertions.assertThat((Double)metric.getBestValue()).isNull();
        Assertions.assertThat((String)metric.getDescription()).isNull();
        Assertions.assertThat((Double)metric.getWorstValue()).isNull();
        Assertions.assertThat((Integer)metric.getDirection()).isEqualTo(0);
        Assertions.assertThat((Boolean)metric.getEnabled()).isTrue();
        Assertions.assertThat((Object)metric.getFormula()).isNull();
        Assertions.assertThat((Integer)metric.getId()).isNull();
        Assertions.assertThat((Boolean)metric.getUserManaged()).isFalse();
        Assertions.assertThat((Boolean)metric.isHidden()).isFalse();
        Assertions.assertThat((Boolean)metric.isOptimizedBestValue()).isFalse();
    }

    @Test
    public void shouldCreatePercentMetricWithDefaultValues() {
        Metric better = new Metric.Builder("foo", "Foo", Metric.ValueType.PERCENT).setDirection(Integer.valueOf(1)).create();
        Metric worst = new Metric.Builder("foo", "Foo", Metric.ValueType.PERCENT).setDirection(Integer.valueOf(-1)).create();
        Assertions.assertThat((Double)better.getBestValue()).isEqualTo(100.0);
        Assertions.assertThat((Double)better.getWorstValue()).isEqualTo(0.0);
        Assertions.assertThat((Double)worst.getBestValue()).isEqualTo(0.0);
        Assertions.assertThat((Double)worst.getWorstValue()).isEqualTo(100.0);
    }

    @Test
    public void override_decimal_scale_of_float_metric() {
        Metric metric = new Metric.Builder("foo", "Foo", Metric.ValueType.FLOAT).setDecimalScale(3).create();
        Assertions.assertThat((Integer)metric.getDecimalScale()).isEqualTo(3);
    }

    @Test
    public void fail_if_decimal_scale_is_greater_than_max_supported_value() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("Scale of decimal metric [foo] must be less than or equal 5: 6");
        new Metric.Builder("foo", "Foo", Metric.ValueType.FLOAT).setDecimalScale(6).create();
    }

    @Test
    public void override_decimal_scale_of_percent_metric() {
        Metric metric = new Metric.Builder("foo", "Foo", Metric.ValueType.PERCENT).setDecimalScale(3).create();
        Assertions.assertThat((Integer)metric.getDecimalScale()).isEqualTo(3);
    }

    @Test
    public void default_decimal_scale_is_1() {
        Metric metric = new Metric.Builder("foo", "Foo", Metric.ValueType.FLOAT).create();
        Assertions.assertThat((Integer)metric.getDecimalScale()).isEqualTo(1);
    }

    @Test
    public void non_decimal_metric_has_no_scale() {
        Metric metric = new Metric.Builder("foo", "Foo", Metric.ValueType.INT).create();
        Assertions.assertThat((Integer)metric.getDecimalScale()).isNull();
    }
}

