/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.measures;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.Measure;
import org.sonar.api.measures.MeasuresFilter;
import org.sonar.api.measures.MeasuresFilters;
import org.sonar.api.measures.Metric;
import org.sonar.api.measures.RuleMeasure;
import org.sonar.api.rules.Rule;
import org.sonar.api.rules.RulePriority;

public class MeasuresFiltersTest {
    @Test
    public void metric() {
        MeasuresFilter filter = MeasuresFilters.metric((org.sonar.api.batch.measure.Metric)CoreMetrics.VIOLATIONS);
        List<Measure> measures = Arrays.asList(RuleMeasure.createForPriority((Metric)CoreMetrics.VIOLATIONS, (RulePriority)RulePriority.CRITICAL, (Double)50.0), new Measure(CoreMetrics.VIOLATIONS, Double.valueOf(500.0)));
        Assert.assertThat((Object)((Measure)filter.filter(measures)).getValue(), (Matcher)Is.is((Object)500.0));
    }

    @Test
    public void all() {
        List<Measure> measures = Arrays.asList(RuleMeasure.createForPriority((Metric)CoreMetrics.VIOLATIONS, (RulePriority)RulePriority.CRITICAL, (Double)50.0), new Measure(CoreMetrics.VIOLATIONS, Double.valueOf(500.0)));
        Iterator filteredMeasures = ((Collection)MeasuresFilters.all().filter(measures)).iterator();
        filteredMeasures.next();
        filteredMeasures.next();
        Assert.assertThat((Object)filteredMeasures.hasNext(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void rule() {
        Rule rule1 = new Rule("pmd", "key1");
        Rule rule2 = new Rule("pmd", "key2");
        MeasuresFilter filter = MeasuresFilters.rule((Metric)CoreMetrics.VIOLATIONS, (Rule)rule1);
        List<Measure> measures = Arrays.asList(RuleMeasure.createForRule((Metric)CoreMetrics.VIOLATIONS, (Rule)rule1, (Double)50.0), RuleMeasure.createForRule((Metric)CoreMetrics.VIOLATIONS, (Rule)rule2, (Double)10.0), RuleMeasure.createForRule((Metric)CoreMetrics.INFO_VIOLATIONS, (Rule)rule2, (Double)3.3), RuleMeasure.createForPriority((Metric)CoreMetrics.VIOLATIONS, (RulePriority)RulePriority.CRITICAL, (Double)400.0), RuleMeasure.createForPriority((Metric)CoreMetrics.COVERAGE, (RulePriority)RulePriority.CRITICAL, (Double)400.0), new Measure(CoreMetrics.VIOLATIONS, Double.valueOf(500.0)));
        Assert.assertThat((Object)((RuleMeasure)filter.filter(measures)).getValue(), (Matcher)Is.is((Object)50.0));
    }

    @Test
    public void rules() {
        Rule rule1 = new Rule("pmd", "key1");
        Rule rule2 = new Rule("pmd", "key2");
        MeasuresFilter filter = MeasuresFilters.rules((Metric)CoreMetrics.VIOLATIONS);
        List<Measure> measures = Arrays.asList(RuleMeasure.createForRule((Metric)CoreMetrics.VIOLATIONS, (Rule)rule1, (Double)50.0), RuleMeasure.createForRule((Metric)CoreMetrics.VIOLATIONS, (Rule)rule2, (Double)10.0), RuleMeasure.createForRule((Metric)CoreMetrics.INFO_VIOLATIONS, (Rule)rule2, (Double)3.3), RuleMeasure.createForPriority((Metric)CoreMetrics.VIOLATIONS, (RulePriority)RulePriority.CRITICAL, (Double)400.0), RuleMeasure.createForPriority((Metric)CoreMetrics.COVERAGE, (RulePriority)RulePriority.CRITICAL, (Double)400.0), new Measure(CoreMetrics.VIOLATIONS, Double.valueOf(500.0)));
        Assert.assertThat((Object)((Collection)filter.filter(measures)).size(), (Matcher)Is.is((Object)2));
    }

    @Test
    public void measure() {
        MeasuresFilter filter = MeasuresFilters.measure((Measure)new Measure(CoreMetrics.VIOLATIONS));
        List<Measure> measures = Arrays.asList(new Measure(CoreMetrics.COMMENT_LINES, Double.valueOf(50.0)), new Measure(CoreMetrics.VIOLATIONS, Double.valueOf(10.0)), RuleMeasure.createForCategory((Metric)CoreMetrics.VIOLATIONS, (Integer)2, (Double)12.0), new Measure(CoreMetrics.COVERAGE, Double.valueOf(15.0)));
        Assert.assertThat((Object)((Measure)filter.filter(measures)).getValue(), (Matcher)Is.is((Object)10.0));
    }
}

