/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.measures;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.Measure;
import org.sonar.api.measures.MeasureUtils;

public class MeasureUtilsTest {
    @Test
    public void getValue() {
        Assert.assertThat((Object)MeasureUtils.getValue(null, (Double)3.0), (Matcher)Matchers.is((Object)3.0));
        Assert.assertThat((Object)MeasureUtils.getValue((Measure)new Measure(), (Double)3.0), (Matcher)Matchers.is((Object)3.0));
        Assert.assertThat((Object)MeasureUtils.getValue((Measure)new Measure(CoreMetrics.LINES, Double.valueOf(2.0)), (Double)3.0), (Matcher)Matchers.is((Object)2.0));
        Assert.assertThat((Object)MeasureUtils.getValue((Measure)new Measure(CoreMetrics.LINES, "data"), (Double)3.0), (Matcher)Matchers.is((Object)3.0));
    }

    @Test
    public void sumNone() {
        Assert.assertThat((Object)MeasureUtils.sum((boolean)true, (Measure[])new Measure[0]), (Matcher)Matchers.is((Object)0.0));
        Assert.assertNull((Object)MeasureUtils.sum((boolean)false, (Measure[])new Measure[0]));
    }

    @Test
    public void shouldNotFailIfDataMeasures() {
        Assert.assertThat((Object)MeasureUtils.sum((boolean)true, (Measure[])new Measure[]{new Measure(CoreMetrics.ALERT_STATUS, "foo"), new Measure(CoreMetrics.LINES, Double.valueOf(50.0))}), (Matcher)Matchers.is((Object)50.0));
    }

    @Test
    public void sumNumericMeasures() {
        Assert.assertThat((Object)MeasureUtils.sum((boolean)true, (Measure[])new Measure[]{new Measure(CoreMetrics.LINES, Double.valueOf(80.0)), new Measure(CoreMetrics.LINES, Double.valueOf(50.0))}), (Matcher)Matchers.is((Object)130.0));
        Assert.assertThat((Object)MeasureUtils.sum((boolean)true, Arrays.asList(new Measure(CoreMetrics.LINES, Double.valueOf(80.0)), new Measure(CoreMetrics.LINES, Double.valueOf(50.0)))), (Matcher)Matchers.is((Object)130.0));
    }

    @Test
    public void sumNullMeasures() {
        Assert.assertThat((Object)MeasureUtils.sum((boolean)true, (Measure[])new Measure[0]), (Matcher)Matchers.is((Object)0.0));
        Assert.assertThat((Object)MeasureUtils.sum((boolean)true, (Collection)null), (Matcher)Matchers.is((Object)0.0));
        Assert.assertThat((Object)MeasureUtils.sum((boolean)false, (Measure[])new Measure[0]), (Matcher)Matchers.nullValue());
        Assert.assertThat((Object)MeasureUtils.sum((boolean)true, (Measure[])new Measure[]{new Measure(CoreMetrics.LINES, Double.valueOf(80.0)), null, null, new Measure(CoreMetrics.LINES, Double.valueOf(50.0))}), (Matcher)Matchers.is((Object)130.0));
    }

    @Test
    public void hasValue() {
        Assert.assertThat((Object)MeasureUtils.hasValue(null), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)MeasureUtils.hasValue((Measure)new Measure(CoreMetrics.CLASSES, (Double)null)), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)MeasureUtils.hasValue((Measure)new Measure(CoreMetrics.CLASSES, Double.valueOf(3.2))), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void hasData() {
        Assert.assertThat((Object)MeasureUtils.hasData(null), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)MeasureUtils.hasData((Measure)new Measure(CoreMetrics.CLASSES, Double.valueOf(3.5))), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)MeasureUtils.hasData((Measure)new Measure(CoreMetrics.FUNCTION_COMPLEXITY_DISTRIBUTION, (String)null)), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)MeasureUtils.hasData((Measure)new Measure(CoreMetrics.FUNCTION_COMPLEXITY_DISTRIBUTION, "")), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)MeasureUtils.hasData((Measure)new Measure(CoreMetrics.FUNCTION_COMPLEXITY_DISTRIBUTION, "1=10;2=20")), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void shouldHaveValues() {
        Assert.assertThat((Object)MeasureUtils.haveValues((Measure[])new Measure[0]), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)MeasureUtils.haveValues((Measure[])new Measure[]{null, null}), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)MeasureUtils.haveValues((Measure[])new Measure[]{new Measure(CoreMetrics.CLASSES, (Double)null)}), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)MeasureUtils.haveValues((Measure[])new Measure[]{new Measure(CoreMetrics.CLASSES, Double.valueOf(3.2))}), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)MeasureUtils.haveValues((Measure[])new Measure[]{new Measure(CoreMetrics.CLASSES, Double.valueOf(3.2)), new Measure(CoreMetrics.COMPLEXITY, "foo")}), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)MeasureUtils.haveValues((Measure[])new Measure[]{new Measure(CoreMetrics.CLASSES, Double.valueOf(3.2)), new Measure(CoreMetrics.COMPLEXITY, Double.valueOf(2.5))}), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void shouldGetVariation() {
        Assert.assertThat((Object)MeasureUtils.getVariation(null, (int)2, (Double)3.14), (Matcher)Matchers.is((Object)3.14));
        Assert.assertThat((Object)MeasureUtils.getVariation(null, (int)2), (Matcher)Matchers.nullValue());
        Assert.assertThat((Object)MeasureUtils.getVariation((Measure)new Measure(), (int)2, (Double)3.14), (Matcher)Matchers.is((Object)3.14));
        Assert.assertThat((Object)MeasureUtils.getVariation((Measure)new Measure(), (int)2), (Matcher)Matchers.nullValue());
        Assert.assertThat((Object)MeasureUtils.getVariation((Measure)new Measure().setVariation2(Double.valueOf(1.618)), (int)2, (Double)3.14), (Matcher)Matchers.is((Object)1.618));
    }

    @Test
    public void shouldGetVariationAsLong() {
        Assert.assertThat((Object)MeasureUtils.getVariationAsLong(null, (int)2, (Long)3L), (Matcher)Matchers.is((Object)3L));
        Assert.assertThat((Object)MeasureUtils.getVariationAsLong(null, (int)2), (Matcher)Matchers.nullValue());
        Assert.assertThat((Object)MeasureUtils.getVariationAsLong((Measure)new Measure(), (int)2, (Long)3L), (Matcher)Matchers.is((Object)3L));
        Assert.assertThat((Object)MeasureUtils.getVariationAsLong((Measure)new Measure(), (int)2), (Matcher)Matchers.nullValue());
        Assert.assertThat((Object)MeasureUtils.getVariationAsLong((Measure)new Measure().setVariation2(Double.valueOf(222.0)), (int)2, (Long)3L), (Matcher)Matchers.is((Object)222L));
    }

    @Test
    public void shouldSumOnVariation() {
        Measure measure1 = new Measure(CoreMetrics.NEW_VIOLATIONS).setVariation1(Double.valueOf(1.0)).setVariation2(Double.valueOf(1.0)).setVariation3(Double.valueOf(3.0));
        Measure measure2 = new Measure(CoreMetrics.NEW_VIOLATIONS).setVariation1(Double.valueOf(1.0)).setVariation2(Double.valueOf(2.0)).setVariation3(Double.valueOf(3.0));
        List<Measure> children = Arrays.asList(measure1, measure2);
        Assert.assertThat((Object)MeasureUtils.sumOnVariation((boolean)true, (int)1, children), (Matcher)Matchers.is((Object)2.0));
        Assert.assertThat((Object)MeasureUtils.sumOnVariation((boolean)true, (int)2, children), (Matcher)Matchers.is((Object)3.0));
        Assert.assertThat((Object)MeasureUtils.sumOnVariation((boolean)true, (int)3, children), (Matcher)Matchers.is((Object)6.0));
    }
}

