/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.measures;

import org.apache.commons.lang.StringUtils;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.Measure;
import org.sonar.api.measures.Metric;
import org.sonar.api.measures.PersistenceMode;
import org.sonar.api.measures.RuleMeasure;
import org.sonar.api.rules.Rule;
import org.sonar.api.rules.RulePriority;

public class MeasureTest {
    @org.junit.Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void valueCanBeNull() {
        Measure measure = new Measure("metric_key").setValue(null);
        Assertions.assertThat((Double)measure.getValue()).isNull();
    }

    @Test
    public void valueShouldNotBeNaN() {
        this.thrown.expect(IllegalArgumentException.class);
        new Measure("metric_key").setValue(Double.valueOf(Double.NaN));
    }

    @Test
    public void defaultPersistenceModeIsFull() {
        Assertions.assertThat((Comparable)new Measure(CoreMetrics.LINES, Double.valueOf(32.0)).getPersistenceMode()).isEqualTo((Object)PersistenceMode.FULL);
    }

    @Test
    public void persistenceModeIsDatabaseForBigDataMeasures() {
        Measure bigDataMeasure = new Measure(CoreMetrics.COVERAGE_LINE_HITS_DATA, "long data").setPersistenceMode(PersistenceMode.DATABASE);
        Assertions.assertThat((Comparable)bigDataMeasure.getPersistenceMode()).isEqualTo((Object)PersistenceMode.DATABASE);
    }

    @Test
    public void measureWithLevelValue() {
        Assertions.assertThat((String)new Measure(CoreMetrics.ALERT_STATUS, Metric.Level.ERROR).getData()).isEqualTo((Object)"ERROR");
        Assertions.assertThat((Comparable)new Measure(CoreMetrics.ALERT_STATUS, Metric.Level.ERROR).getDataAsLevel()).isEqualTo((Object)Metric.Level.ERROR);
        Assertions.assertThat((Comparable)new Measure(CoreMetrics.ALERT_STATUS).setData(Metric.Level.ERROR).getDataAsLevel()).isEqualTo((Object)Metric.Level.ERROR);
    }

    @Test
    public void measureWithIntegerValue() {
        Assertions.assertThat((Double)new Measure(CoreMetrics.LINES).setIntValue(Integer.valueOf(3)).getValue()).isEqualTo(3.0);
        Assertions.assertThat((Double)new Measure(CoreMetrics.LINES).setIntValue(null).getValue()).isNull();
        Assertions.assertThat((Integer)new Measure(CoreMetrics.LINES).setIntValue(Integer.valueOf(3)).getIntValue()).isEqualTo(3);
        Assertions.assertThat((Integer)new Measure(CoreMetrics.LINES).setIntValue(null).getIntValue()).isNull();
        Assertions.assertThat((Integer)new Measure(CoreMetrics.LINES).setValue(Double.valueOf(3.6)).getIntValue()).isEqualTo(3);
    }

    @Test
    public void equalsAndHashCode() {
        Measure measure1 = new Measure();
        Measure measure2 = new Measure();
        Assertions.assertThat((boolean)measure1.equals(null)).isFalse();
        Assertions.assertThat((boolean)measure1.equals((Object)"")).isFalse();
        Assertions.assertThat((boolean)measure1.equals((Object)measure1)).isTrue();
        Assertions.assertThat((int)measure1.hashCode()).isEqualTo(measure2.hashCode());
        Assertions.assertThat((boolean)measure1.equals((Object)measure2)).isTrue();
        Assertions.assertThat((boolean)measure2.equals((Object)measure1)).isTrue();
        Assertions.assertThat((int)measure1.hashCode()).isEqualTo(measure2.hashCode());
        measure1.setMetric(CoreMetrics.COVERAGE);
        Assertions.assertThat((boolean)measure1.equals((Object)measure2)).isFalse();
        Assertions.assertThat((boolean)measure2.equals((Object)measure1)).isFalse();
        Assertions.assertThat((int)measure1.hashCode()).isNotEqualTo(measure2.hashCode());
        measure2.setMetric(CoreMetrics.LINES);
        Assertions.assertThat((boolean)measure1.equals((Object)measure2)).isFalse();
        Assertions.assertThat((boolean)measure2.equals((Object)measure1)).isFalse();
        Assertions.assertThat((int)measure1.hashCode()).isNotEqualTo(measure2.hashCode());
        measure2.setMetric(CoreMetrics.COVERAGE);
        Assertions.assertThat((boolean)measure1.equals((Object)measure2)).isTrue();
        Assertions.assertThat((boolean)measure2.equals((Object)measure1)).isTrue();
        Assertions.assertThat((int)measure1.hashCode()).isEqualTo(measure2.hashCode());
        measure1.setPersonId(Integer.valueOf(1));
        Assertions.assertThat((boolean)measure1.equals((Object)measure2)).isFalse();
        Assertions.assertThat((boolean)measure2.equals((Object)measure1)).isFalse();
        Assertions.assertThat((int)measure1.hashCode()).isNotEqualTo(measure2.hashCode());
        measure2.setPersonId(Integer.valueOf(2));
        Assertions.assertThat((boolean)measure1.equals((Object)measure2)).isFalse();
        Assertions.assertThat((boolean)measure2.equals((Object)measure1)).isFalse();
        Assertions.assertThat((int)measure1.hashCode()).isNotEqualTo(measure2.hashCode());
        measure2.setPersonId(Integer.valueOf(1));
        Assertions.assertThat((boolean)measure1.equals((Object)measure2)).isTrue();
        Assertions.assertThat((boolean)measure2.equals((Object)measure1)).isTrue();
        Assertions.assertThat((int)measure1.hashCode()).isEqualTo(measure2.hashCode());
        measure1.setValue(Double.valueOf(1.0));
        measure2.setValue(Double.valueOf(2.0));
        Assertions.assertThat((boolean)measure1.equals((Object)measure2)).isTrue();
        Assertions.assertThat((boolean)measure2.equals((Object)measure1)).isTrue();
        Assertions.assertThat((int)measure1.hashCode()).isEqualTo(measure2.hashCode());
    }

    @Test
    public void longDataForDataMetric() {
        new Measure(CoreMetrics.COVERAGE_LINE_HITS_DATA, StringUtils.repeat((String)"x", (int)97));
    }

    @Test
    public void shouldGetAndSetVariations() {
        Measure measure = new Measure(CoreMetrics.LINES).setVariation1(Double.valueOf(1.0)).setVariation2(Double.valueOf(2.0)).setVariation3(Double.valueOf(3.0));
        Assertions.assertThat((Double)measure.getVariation1()).isEqualTo(1.0);
        Assertions.assertThat((Double)measure.getVariation2()).isEqualTo(2.0);
        Assertions.assertThat((Double)measure.getVariation3()).isEqualTo(3.0);
    }

    @Test
    public void shouldSetVariationsWithIndex() {
        Measure measure = new Measure(CoreMetrics.LINES).setVariation(2, Double.valueOf(3.3));
        Assertions.assertThat((Double)measure.getVariation1()).isNull();
        Assertions.assertThat((Double)measure.getVariation2()).isEqualTo(3.3);
        Assertions.assertThat((Double)measure.getVariation3()).isNull();
    }

    @Test
    public void notEqualRuleMeasures() {
        Measure measure = new Measure(CoreMetrics.VIOLATIONS, Double.valueOf(30.0));
        RuleMeasure ruleMeasure = new RuleMeasure(CoreMetrics.VIOLATIONS, new Rule("foo", "bar"), RulePriority.CRITICAL, Integer.valueOf(3));
        Assertions.assertThat((boolean)measure.equals((Object)ruleMeasure)).isFalse();
        Assertions.assertThat((boolean)ruleMeasure.equals((Object)measure)).isFalse();
    }

    @Test
    public void shouldUnsetData() {
        String data = "1=10;21=456";
        Measure measure = new Measure(CoreMetrics.CONDITIONS_BY_LINE).setData(data);
        Assertions.assertThat((boolean)measure.hasData()).isTrue();
        Assertions.assertThat((String)measure.getData()).isEqualTo((Object)data);
        measure.unsetData();
        Assertions.assertThat((boolean)measure.hasData()).isFalse();
        Assertions.assertThat((String)measure.getData()).isNull();
    }

    @Test
    public void null_value_and_null_variations_should_be_considered_as_best_value() {
        Assertions.assertThat((boolean)new Measure(CoreMetrics.VIOLATIONS).setVariation1(Double.valueOf(0.0)).isBestValue()).isTrue();
        Assertions.assertThat((boolean)new Measure(CoreMetrics.VIOLATIONS).setVariation1(Double.valueOf(1.0)).isBestValue()).isFalse();
        Assertions.assertThat((boolean)new Measure(CoreMetrics.VIOLATIONS).setVariation2(Double.valueOf(1.0)).isBestValue()).isFalse();
        Assertions.assertThat((boolean)new Measure(CoreMetrics.VIOLATIONS).setVariation3(Double.valueOf(1.0)).isBestValue()).isFalse();
        Assertions.assertThat((boolean)new Measure(CoreMetrics.VIOLATIONS).setVariation4(Double.valueOf(1.0)).isBestValue()).isFalse();
        Assertions.assertThat((boolean)new Measure(CoreMetrics.VIOLATIONS).setVariation5(Double.valueOf(1.0)).isBestValue()).isFalse();
    }

    @Test
    public void testBooleanValue() {
        Assertions.assertThat((Object)new Measure(new Metric.Builder("foo", "Sample boolean", Metric.ValueType.BOOL).create()).setValue(Double.valueOf(1.0)).value()).isEqualTo((Object)Boolean.TRUE);
        Assertions.assertThat((Object)new Measure(new Metric.Builder("foo", "Sample boolean", Metric.ValueType.BOOL).create()).setValue(Double.valueOf(0.0)).value()).isEqualTo((Object)Boolean.FALSE);
    }
}

