/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.measures;

import java.util.Collection;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.sonar.api.measures.CoverageMeasuresBuilder;
import org.sonar.api.measures.Measure;

public class CoverageMeasuresBuilderTest {
    @Test
    public void shouldNotCreateIfNoValues() {
        CoverageMeasuresBuilder builder = CoverageMeasuresBuilder.create();
        Assert.assertThat((Object)builder.createMeasures().size(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldCreateHitsByLineData() {
        CoverageMeasuresBuilder builder = CoverageMeasuresBuilder.create();
        builder.setHits(1, 0);
        builder.setHits(2, 3);
        builder.setHits(4, 2);
        Assert.assertThat((Object)this.find(builder.createMeasures(), "coverage_line_hits_data").getData(), (Matcher)Is.is((Object)"1=0;2=3;4=2"));
    }

    @Test
    public void shouldCreateUncoveredLines() {
        CoverageMeasuresBuilder builder = CoverageMeasuresBuilder.create();
        builder.setHits(1, 0);
        builder.setHits(2, 3);
        builder.setHits(3, 0);
        Assert.assertThat((Object)this.find(builder.createMeasures(), "uncovered_lines").getIntValue(), (Matcher)Is.is((Object)2));
    }

    @Test
    public void shouldCreateConditionsByLineData() {
        CoverageMeasuresBuilder builder = CoverageMeasuresBuilder.create();
        builder.setConditions(1, 2, 2);
        builder.setConditions(2, 1, 0);
        Assert.assertThat((Object)this.find(builder.createMeasures(), "conditions_by_line").getData(), (Matcher)Is.is((Object)"1=2;2=1"));
        Assert.assertThat((Object)this.find(builder.createMeasures(), "covered_conditions_by_line").getData(), (Matcher)Is.is((Object)"1=2;2=0"));
    }

    @Test
    public void shouldCreateNumberOfConditionsToCover() {
        CoverageMeasuresBuilder builder = CoverageMeasuresBuilder.create();
        builder.setConditions(1, 2, 2);
        builder.setConditions(2, 1, 0);
        Assert.assertThat((Object)this.find(builder.createMeasures(), "conditions_to_cover").getIntValue(), (Matcher)Is.is((Object)3));
    }

    @Test
    public void shouldCreateNumberOfUncoveredConditions() {
        CoverageMeasuresBuilder builder = CoverageMeasuresBuilder.create();
        builder.setConditions(1, 2, 2);
        builder.setConditions(2, 1, 0);
        builder.setConditions(3, 3, 1);
        Assert.assertThat((Object)this.find(builder.createMeasures(), "uncovered_conditions").getIntValue(), (Matcher)Is.is((Object)3));
    }

    @Test
    public void shouldSetOnlyPositiveConditions() {
        CoverageMeasuresBuilder builder = CoverageMeasuresBuilder.create();
        builder.setConditions(1, 0, 0);
        builder.setConditions(2, 1, 0);
        Assert.assertThat((Object)this.find(builder.createMeasures(), "conditions_by_line").getData(), (Matcher)Is.is((Object)"2=1"));
        Assert.assertThat((Object)this.find(builder.createMeasures(), "covered_conditions_by_line").getData(), (Matcher)Is.is((Object)"2=0"));
    }

    @Test
    public void shouldIgnoreDuplicatedSetHits() {
        CoverageMeasuresBuilder builder = CoverageMeasuresBuilder.create();
        builder.setHits(2, 3);
        builder.setHits(2, 5);
        Assert.assertThat((Object)builder.getLinesToCover(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)builder.getCoveredLines(), (Matcher)Is.is((Object)1));
        Assert.assertThat(builder.getHitsByLine().get(2), (Matcher)Is.is((Object)3));
    }

    @Test
    public void shouldIgnoreDuplicatedSetConditions() {
        CoverageMeasuresBuilder builder = CoverageMeasuresBuilder.create();
        builder.setConditions(1, 3, 2);
        builder.setConditions(1, 1, 0);
        Assert.assertThat((Object)builder.getConditions(), (Matcher)Is.is((Object)3));
        Assert.assertThat((Object)builder.getCoveredConditions(), (Matcher)Is.is((Object)2));
        Assert.assertThat(builder.getConditionsByLine().get(1), (Matcher)Is.is((Object)3));
        Assert.assertThat(builder.getCoveredConditionsByLine().get(1), (Matcher)Is.is((Object)2));
    }

    @Test
    public void shouldResetFields() {
        CoverageMeasuresBuilder builder = CoverageMeasuresBuilder.create();
        builder.setHits(1, 4);
        builder.setConditions(1, 3, 1);
        builder.reset();
        Assert.assertThat((Object)builder.getConditions(), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)builder.getCoveredConditions(), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)builder.getCoveredLines(), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)builder.getHitsByLine().size(), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)builder.getConditionsByLine().size(), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)builder.getCoveredConditionsByLine().size(), (Matcher)Is.is((Object)0));
    }

    private Measure find(Collection<Measure> measures, String metricKey) {
        for (Measure measure : measures) {
            if (!metricKey.equals(measure.getMetricKey())) continue;
            return measure;
        }
        return null;
    }
}

