/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.measures;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.CountDistributionBuilder;
import org.sonar.api.measures.Measure;

public class CountDistributionBuilderTest {
    @Test
    public void buildDistribution() {
        CountDistributionBuilder builder = new CountDistributionBuilder(CoreMetrics.CLASS_COMPLEXITY_DISTRIBUTION);
        Measure measure = builder.add((Object)"foo").add((Object)"bar").add((Object)"foo").add((Object)"hello").build();
        Assert.assertThat((Object)measure.getData(), (Matcher)Matchers.is((Object)"bar=1;foo=2;hello=1"));
    }

    @Test
    public void addZeroValues() {
        CountDistributionBuilder builder = new CountDistributionBuilder(CoreMetrics.CLASS_COMPLEXITY_DISTRIBUTION);
        Measure measure = builder.addZero((Object)"foo").add((Object)"bar").add((Object)"foo").addZero((Object)"hello").build();
        Assert.assertThat((Object)measure.getData(), (Matcher)Matchers.is((Object)"bar=1;foo=1;hello=0"));
    }

    @Test
    public void addDistributionMeasureAsStrings() {
        Measure measureToAdd = (Measure)Mockito.mock(Measure.class);
        Mockito.when((Object)measureToAdd.getData()).thenReturn((Object)"foo=3;hello=5;none=0");
        CountDistributionBuilder builder = new CountDistributionBuilder(CoreMetrics.CLASS_COMPLEXITY_DISTRIBUTION);
        Measure measure = builder.add((Object)"bar").add((Object)"foo").add(measureToAdd).build();
        Assert.assertThat((Object)measure.getData(), (Matcher)Matchers.is((Object)"bar=1;foo=4;hello=5;none=0"));
    }

    @Test
    public void intervalsAreSorted() {
        Measure measureToAdd = (Measure)Mockito.mock(Measure.class);
        Mockito.when((Object)measureToAdd.getData()).thenReturn((Object)"10=5;3=2;1=3");
        CountDistributionBuilder builder = new CountDistributionBuilder(CoreMetrics.CLASS_COMPLEXITY_DISTRIBUTION);
        Measure measure = builder.add((Object)10).add(measureToAdd).add((Object)1).build();
        Assert.assertThat((Object)measure.getData(), (Matcher)Matchers.is((Object)"1=4;3=2;10=6"));
    }
}

