/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.issue.condition;

import org.assertj.core.api.Assertions;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.sonar.api.issue.Issue;
import org.sonar.api.issue.condition.HasIssuePropertyCondition;

public class HasIssuePropertyConditionTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    Issue issue = (Issue)Mockito.mock(Issue.class);

    @Test
    public void should_match() {
        HasIssuePropertyCondition condition = new HasIssuePropertyCondition("foo");
        Assertions.assertThat((boolean)condition.matches(this.issue)).isFalse();
        Mockito.when((Object)this.issue.attribute("foo")).thenReturn((Object)"");
        Assertions.assertThat((boolean)condition.matches(this.issue)).isFalse();
        Mockito.when((Object)this.issue.attribute("foo")).thenReturn((Object)"bar");
        Assertions.assertThat((boolean)condition.matches(this.issue)).isTrue();
    }

    @Test
    public void should_get_property_key() {
        HasIssuePropertyCondition condition = new HasIssuePropertyCondition("foo");
        Assertions.assertThat((String)condition.getPropertyKey()).isEqualTo((Object)"foo");
    }

    @Test
    public void shoul_fail_if_null_property() {
        this.thrown.expect(IllegalArgumentException.class);
        new HasIssuePropertyCondition(null);
    }

    @Test
    public void should_fail_if_empty_property() {
        this.thrown.expect(IllegalArgumentException.class);
        new HasIssuePropertyCondition("");
    }
}

