/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.issue;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.sonar.api.issue.NoSonarFilter;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.scan.issue.filter.FilterableIssue;
import org.sonar.api.scan.issue.filter.IssueFilterChain;

public class NoSonarFilterTest {
    NoSonarFilter filter = new NoSonarFilter();
    IssueFilterChain chain = (IssueFilterChain)Mockito.mock(IssueFilterChain.class);

    @Before
    public void setupChain() {
        Mockito.when((Object)this.chain.accept((FilterableIssue)Matchers.isA(FilterableIssue.class))).thenReturn((Object)true);
    }

    @Test
    public void should_ignore_lines_commented_with_nosonar() {
        FilterableIssue issue = (FilterableIssue)Mockito.mock(FilterableIssue.class);
        Mockito.when((Object)issue.componentKey()).thenReturn((Object)"struts:org.apache.Action");
        Mockito.when((Object)issue.ruleKey()).thenReturn((Object)RuleKey.of((String)"squid", (String)"AvoidCycles"));
        ImmutableSet noSonarLines = ImmutableSet.of((Object)31, (Object)55);
        this.filter.addComponent("struts:org.apache.Action", (Set)noSonarLines);
        Mockito.when((Object)issue.line()).thenReturn(null);
        Assertions.assertThat((boolean)this.filter.accept(issue, this.chain)).isTrue();
        Mockito.when((Object)issue.line()).thenReturn((Object)31);
        Assertions.assertThat((boolean)this.filter.accept(issue, this.chain)).isFalse();
        Mockito.when((Object)issue.line()).thenReturn((Object)222);
        Assertions.assertThat((boolean)this.filter.accept(issue, this.chain)).isTrue();
        ((IssueFilterChain)Mockito.verify((Object)this.chain, (VerificationMode)Mockito.times((int)2))).accept(issue);
    }

    @Test
    public void should_accept_issues_on_no_sonar_rules() {
        FilterableIssue issue = (FilterableIssue)Mockito.mock(FilterableIssue.class);
        Mockito.when((Object)issue.componentKey()).thenReturn((Object)"struts:org.apache.Action");
        Mockito.when((Object)issue.ruleKey()).thenReturn((Object)RuleKey.of((String)"squid", (String)"NoSonarCheck"));
        ImmutableSet noSonarLines = ImmutableSet.of((Object)31, (Object)55);
        this.filter.addComponent("struts:org.apache.Action", (Set)noSonarLines);
        Mockito.when((Object)issue.line()).thenReturn((Object)31);
        Assertions.assertThat((boolean)this.filter.accept(issue, this.chain)).isTrue();
        Mockito.when((Object)issue.line()).thenReturn((Object)222);
        Assertions.assertThat((boolean)this.filter.accept(issue, this.chain)).isTrue();
        ((IssueFilterChain)Mockito.verify((Object)this.chain, (VerificationMode)Mockito.times((int)2))).accept(issue);
    }
}

