/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.internal;

import org.assertj.core.api.Assertions;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.sonar.api.SonarProduct;
import org.sonar.api.SonarQubeSide;
import org.sonar.api.SonarRuntime;
import org.sonar.api.internal.SonarRuntimeImpl;
import org.sonar.api.utils.Version;

public class SonarRuntimeImplTest {
    private static final Version A_VERSION = Version.parse((String)"6.0");
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void sonarQube_environment() {
        SonarRuntime apiVersion = SonarRuntimeImpl.forSonarQube((Version)A_VERSION, (SonarQubeSide)SonarQubeSide.SCANNER);
        Assertions.assertThat((Comparable)apiVersion.getApiVersion()).isEqualTo((Object)A_VERSION);
        Assertions.assertThat((Comparable)apiVersion.getProduct()).isEqualTo((Object)SonarProduct.SONARQUBE);
        Assertions.assertThat((Comparable)apiVersion.getSonarQubeSide()).isEqualTo((Object)SonarQubeSide.SCANNER);
    }

    @Test
    public void sonarLint_environment() {
        SonarRuntime apiVersion = SonarRuntimeImpl.forSonarLint((Version)A_VERSION);
        Assertions.assertThat((Comparable)apiVersion.getApiVersion()).isEqualTo((Object)A_VERSION);
        Assertions.assertThat((Comparable)apiVersion.getProduct()).isEqualTo((Object)SonarProduct.SONARLINT);
        try {
            apiVersion.getSonarQubeSide();
            Assertions.fail((String)"Expected exception");
        }
        catch (Exception e) {
            Assertions.assertThat((Throwable)e).isInstanceOf(UnsupportedOperationException.class);
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void sonarqube_requires_side() throws Exception {
        SonarRuntimeImpl.forSonarQube((Version)A_VERSION, null);
    }
}

