/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.internal;

import java.io.File;
import org.assertj.core.api.Assertions;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.sonar.api.internal.ApiVersion;
import org.sonar.api.utils.System2;
import org.sonar.api.utils.Version;

public class ApiVersionTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void load_version_from_file_in_classpath() {
        Version version = ApiVersion.load((System2)System2.INSTANCE);
        Assertions.assertThat((Comparable)version).isNotNull();
        Assertions.assertThat((int)version.major()).isGreaterThanOrEqualTo(5);
    }

    @Test
    public void throw_ISE_if_fail_to_load_version() throws Exception {
        this.expectedException.expect(IllegalStateException.class);
        this.expectedException.expectMessage("Can not load /sonar-api-version.txt from classpath");
        System2 system = (System2)Mockito.spy(System2.class);
        Mockito.when((Object)system.getResource(Matchers.anyString())).thenReturn((Object)new File("target/unknown").toURI().toURL());
        ApiVersion.load((System2)system);
    }
}

