/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.config;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.sonar.api.Properties;
import org.sonar.api.Property;
import org.sonar.api.config.Category;
import org.sonar.api.config.PropertyDefinition;
import org.sonar.api.config.PropertyDefinitions;
import org.sonar.api.config.SubCategory;

public class PropertyDefinitionsTest {
    @Test
    public void should_build_with_predefined_list_of_definitions() {
        List<PropertyDefinition> list = Arrays.asList(PropertyDefinition.builder((String)"foo").name("Foo").build(), PropertyDefinition.builder((String)"one").name("One").build(), PropertyDefinition.builder((String)"two").name("Two").defaultValue("2").build());
        PropertyDefinitions def = new PropertyDefinitions(list);
        this.assertProperties(def);
    }

    @Test
    public void should_inspect_plugin_objects() {
        PropertyDefinitions def = new PropertyDefinitions(new Object[]{PropertyDefinition.builder((String)"foo").name("Foo").build(), PropertyDefinition.builder((String)"one").name("One").build(), PropertyDefinition.builder((String)"two").name("Two").defaultValue("2").build()});
        this.assertProperties(def);
    }

    @Test
    public void should_inspect_annotation_plugin_objects() {
        PropertyDefinitions def = new PropertyDefinitions(new Object[]{new PluginWithProperty(), new PluginWithProperties()});
        this.assertProperties(def);
    }

    @Test
    public void should_inspect_plugin_classes() {
        PropertyDefinitions def = new PropertyDefinitions(new Object[]{PluginWithProperty.class, PluginWithProperties.class});
        this.assertProperties(def);
    }

    @Test
    public void test_categories() {
        PropertyDefinitions def = new PropertyDefinitions(new Object[]{PropertyDefinition.builder((String)"inCateg").name("In Categ").category("categ").build(), PropertyDefinition.builder((String)"noCateg").name("No categ").build()});
        Assertions.assertThat((String)def.getCategory("inCateg")).isEqualTo((Object)"categ");
        Assertions.assertThat((String)def.getCategory("noCateg")).isEmpty();
    }

    @Test
    public void test_categories_on_annotation_plugin() {
        PropertyDefinitions def = new PropertyDefinitions(new Object[]{Categories.class});
        Assertions.assertThat((String)def.getCategory("inCateg")).isEqualTo((Object)"categ");
        Assertions.assertThat((String)def.getCategory("noCateg")).isEqualTo((Object)"");
    }

    @Test
    public void test_default_category() {
        PropertyDefinitions def = new PropertyDefinitions(new Object[0]);
        def.addComponent((Object)PropertyDefinition.builder((String)"inCateg").name("In Categ").category("categ").build(), "default");
        def.addComponent((Object)PropertyDefinition.builder((String)"noCateg").name("No categ").build(), "default");
        Assertions.assertThat((String)def.getCategory("inCateg")).isEqualTo((Object)"categ");
        Assertions.assertThat((String)def.getCategory("noCateg")).isEqualTo((Object)"default");
    }

    @Test
    public void test_default_category_on_annotation_plugin() {
        PropertyDefinitions def = new PropertyDefinitions(new Object[0]);
        def.addComponent(Categories.class, "default");
        Assertions.assertThat((String)def.getCategory("inCateg")).isEqualTo((Object)"categ");
        Assertions.assertThat((String)def.getCategory("noCateg")).isEqualTo((Object)"default");
    }

    @Test
    public void should_return_special_categories() {
        PropertyDefinitions def = new PropertyDefinitions(new Object[0]);
        Assertions.assertThat(((Map)def.propertiesByCategory(null).get(new Category("general"))).keySet()).containsOnly((Object[])new SubCategory[]{new SubCategory("email")});
        Assertions.assertThat((boolean)((SubCategory)((Map)def.propertiesByCategory(null).get(new Category("general"))).keySet().iterator().next()).isSpecial()).isTrue();
        Assertions.assertThat(((Map)def.propertiesByCategory(null).get(new Category("security"))).keySet()).containsOnly((Object[])new SubCategory[]{new SubCategory("encryption")});
        Assertions.assertThat((boolean)((SubCategory)((Map)def.propertiesByCategory(null).get(new Category("security"))).keySet().iterator().next()).isSpecial()).isTrue();
        Assertions.assertThat(((Map)def.propertiesByCategory(null).get(new Category("licenses"))).keySet()).containsOnly((Object[])new SubCategory[]{new SubCategory("server_id")});
        Assertions.assertThat((boolean)((SubCategory)((Map)def.propertiesByCategory(null).get(new Category("licenses"))).keySet().iterator().next()).isSpecial()).isTrue();
    }

    @Test
    public void should_group_by_category() {
        PropertyDefinitions def = new PropertyDefinitions(new Object[]{PropertyDefinition.builder((String)"global1").name("Global1").category("catGlobal1").build(), PropertyDefinition.builder((String)"global2").name("Global2").category("catGlobal1").build(), PropertyDefinition.builder((String)"global3").name("Global3").category("catGlobal2").build(), PropertyDefinition.builder((String)"project").name("Project").category("catProject").onlyOnQualifiers("TRK", new String[0]).build(), PropertyDefinition.builder((String)"module").name("Module").category("catModule").onlyOnQualifiers("BRC", new String[0]).build(), PropertyDefinition.builder((String)"view").name("View").category("catView").onlyOnQualifiers("VW", new String[0]).build()});
        Assertions.assertThat(def.propertiesByCategory(null).keySet()).contains((Object[])new Category[]{new Category("catGlobal1"), new Category("catGlobal2")});
        Assertions.assertThat(def.propertiesByCategory("TRK").keySet()).containsOnly((Object[])new Category[]{new Category("catProject")});
        Assertions.assertThat(def.propertiesByCategory("BRC").keySet()).containsOnly((Object[])new Category[]{new Category("catModule")});
        Assertions.assertThat(def.propertiesByCategory("VW").keySet()).containsOnly((Object[])new Category[]{new Category("catView")});
        Assertions.assertThat(def.propertiesByCategory("Unkown").keySet()).isEmpty();
    }

    @Test
    public void should_group_by_subcategory() {
        PropertyDefinitions def = new PropertyDefinitions(new Object[]{PropertyDefinition.builder((String)"global1").name("Global1").category("catGlobal1").subCategory("sub1").build(), PropertyDefinition.builder((String)"global2").name("Global2").category("catGlobal1").subCategory("sub2").build(), PropertyDefinition.builder((String)"global3").name("Global3").category("catGlobal1").build(), PropertyDefinition.builder((String)"global4").name("Global4").category("catGlobal2").build()});
        Assertions.assertThat(((Map)def.propertiesByCategory(null).get(new Category("catGlobal1"))).keySet()).containsOnly((Object[])new SubCategory[]{new SubCategory("catGlobal1"), new SubCategory("sub1"), new SubCategory("sub2")});
        Assertions.assertThat(((Map)def.propertiesByCategory(null).get(new Category("catGlobal2"))).keySet()).containsOnly((Object[])new SubCategory[]{new SubCategory("catGlobal2")});
    }

    @Test
    public void should_group_by_category_on_annotation_plugin() {
        PropertyDefinitions def = new PropertyDefinitions(new Object[]{ByCategory.class});
        Assertions.assertThat(def.propertiesByCategory(null).keySet()).contains((Object[])new Category[]{new Category("catglobal1"), new Category("catglobal2")});
        Assertions.assertThat(def.propertiesByCategory("TRK").keySet()).containsOnly((Object[])new Category[]{new Category("catproject")});
        Assertions.assertThat(def.propertiesByCategory("BRC").keySet()).containsOnly((Object[])new Category[]{new Category("catmodule")});
    }

    private void assertProperties(PropertyDefinitions definitions) {
        Assertions.assertThat((String)definitions.get("foo").name()).isEqualTo((Object)"Foo");
        Assertions.assertThat((String)definitions.get("one").name()).isEqualTo((Object)"One");
        Assertions.assertThat((String)definitions.get("two").name()).isEqualTo((Object)"Two");
        Assertions.assertThat((Object)definitions.get("unknown")).isNull();
        Assertions.assertThat((String)definitions.getDefaultValue("foo")).isNull();
        Assertions.assertThat((String)definitions.getDefaultValue("two")).isEqualTo((Object)"2");
        Assertions.assertThat((int)definitions.getAll().size()).isEqualTo(3);
    }

    @Properties(value={@Property(key="global1", name="Global1", category="catGlobal1", global=true, project=false, module=false), @Property(key="global2", name="Global2", category="catGlobal1", global=true, project=false, module=false), @Property(key="global3", name="Global3", category="catGlobal2", global=true, project=false, module=false), @Property(key="project", name="Project", category="catProject", global=false, project=true, module=false), @Property(key="module", name="Module", category="catModule", global=false, project=false, module=true)})
    static final class ByCategory {
        ByCategory() {
        }
    }

    @Properties(value={@Property(key="inCateg", name="In Categ", category="categ"), @Property(key="noCateg", name="No categ")})
    static final class Categories {
        Categories() {
        }
    }

    @Properties(value={@Property(key="one", name="One"), @Property(key="two", name="Two", defaultValue="2")})
    static final class PluginWithProperties {
        PluginWithProperties() {
        }
    }

    @Property(key="foo", name="Foo")
    static final class PluginWithProperty {
        PluginWithProperty() {
        }
    }
}

