/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.config;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.sonar.api.Properties;
import org.sonar.api.Property;
import org.sonar.api.PropertyField;
import org.sonar.api.PropertyType;
import org.sonar.api.config.PropertyDefinition;
import org.sonar.api.config.PropertyFieldDefinition;
import org.sonar.api.utils.AnnotationUtils;

public class PropertyDefinitionTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void should_override_toString() {
        PropertyDefinition def = PropertyDefinition.builder((String)"hello").build();
        Assertions.assertThat((String)def.toString()).isEqualTo((Object)"hello");
    }

    @Test
    public void should_create_property() {
        PropertyDefinition def = PropertyDefinition.builder((String)"hello").name("Hello").defaultValue("world").category("categ").options("de", new String[]{"en"}).description("desc").type(PropertyType.FLOAT).onlyOnQualifiers("FIL", new String[0]).multiValues(true).propertySetKey("set").build();
        Assertions.assertThat((String)def.key()).isEqualTo((Object)"hello");
        Assertions.assertThat((String)def.name()).isEqualTo((Object)"Hello");
        Assertions.assertThat((String)def.defaultValue()).isEqualTo((Object)"world");
        Assertions.assertThat((String)def.category()).isEqualTo((Object)"categ");
        Assertions.assertThat((List)def.options()).containsOnly((Object[])new String[]{"de", "en"});
        Assertions.assertThat((String)def.description()).isEqualTo((Object)"desc");
        Assertions.assertThat((Comparable)def.type()).isEqualTo((Object)PropertyType.FLOAT);
        Assertions.assertThat((boolean)def.global()).isFalse();
        Assertions.assertThat((List)def.qualifiers()).containsOnly((Object[])new String[]{"FIL"});
        Assertions.assertThat((boolean)def.multiValues()).isTrue();
        Assertions.assertThat((String)def.propertySetKey()).isEqualTo((Object)"set");
        Assertions.assertThat((List)def.fields()).isEmpty();
    }

    @Test
    public void should_create_from_annotation() {
        Properties props = (Properties)AnnotationUtils.getAnnotation(Init.class, Properties.class);
        Property prop = props.value()[0];
        PropertyDefinition def = PropertyDefinition.create((Property)prop);
        Assertions.assertThat((String)def.key()).isEqualTo((Object)"hello");
        Assertions.assertThat((String)def.name()).isEqualTo((Object)"Hello");
        Assertions.assertThat((String)def.defaultValue()).isEqualTo((Object)"world");
        Assertions.assertThat((String)def.category()).isEqualTo((Object)"categ");
        Assertions.assertThat((List)def.options()).containsOnly((Object[])new String[]{"de", "en"});
        Assertions.assertThat((String)def.description()).isEqualTo((Object)"desc");
        Assertions.assertThat((Comparable)def.type()).isEqualTo((Object)PropertyType.FLOAT);
        Assertions.assertThat((boolean)def.global()).isFalse();
        Assertions.assertThat((List)def.qualifiers()).containsOnly((Object[])new String[]{"TRK", "BRC"});
        Assertions.assertThat((boolean)def.multiValues()).isTrue();
        Assertions.assertThat((String)def.propertySetKey()).isEqualTo((Object)"set");
        Assertions.assertThat((List)def.fields()).isEmpty();
    }

    @Test
    public void should_create_hidden_property() {
        PropertyDefinition def = PropertyDefinition.builder((String)"hello").name("Hello").hidden().build();
        Assertions.assertThat((String)def.key()).isEqualTo((Object)"hello");
        Assertions.assertThat((List)def.qualifiers()).isEmpty();
        Assertions.assertThat((boolean)def.global()).isFalse();
    }

    @Test
    public void should_create_property_with_default_values() {
        PropertyDefinition def = PropertyDefinition.builder((String)"hello").name("Hello").build();
        Assertions.assertThat((String)def.key()).isEqualTo((Object)"hello");
        Assertions.assertThat((String)def.name()).isEqualTo((Object)"Hello");
        Assertions.assertThat((String)def.defaultValue()).isEmpty();
        Assertions.assertThat((String)def.category()).isEmpty();
        Assertions.assertThat((List)def.options()).isEmpty();
        Assertions.assertThat((String)def.description()).isEmpty();
        Assertions.assertThat((Comparable)def.type()).isEqualTo((Object)PropertyType.STRING);
        Assertions.assertThat((boolean)def.global()).isTrue();
        Assertions.assertThat((List)def.qualifiers()).isEmpty();
        Assertions.assertThat((boolean)def.multiValues()).isFalse();
        Assertions.assertThat((String)def.propertySetKey()).isEmpty();
        Assertions.assertThat((List)def.fields()).isEmpty();
    }

    @Test
    public void should_create_from_annotation_default_values() {
        Properties props = (Properties)AnnotationUtils.getAnnotation(DefaultValues.class, Properties.class);
        Property prop = props.value()[0];
        PropertyDefinition def = PropertyDefinition.create((Property)prop);
        Assertions.assertThat((String)def.key()).isEqualTo((Object)"hello");
        Assertions.assertThat((String)def.name()).isEqualTo((Object)"Hello");
        Assertions.assertThat((String)def.defaultValue()).isEmpty();
        Assertions.assertThat((String)def.category()).isEmpty();
        Assertions.assertThat((List)def.options()).isEmpty();
        Assertions.assertThat((String)def.description()).isEmpty();
        Assertions.assertThat((Comparable)def.type()).isEqualTo((Object)PropertyType.STRING);
        Assertions.assertThat((boolean)def.global()).isTrue();
        Assertions.assertThat((List)def.qualifiers()).isEmpty();
        Assertions.assertThat((boolean)def.multiValues()).isFalse();
        Assertions.assertThat((String)def.propertySetKey()).isEmpty();
        Assertions.assertThat((List)def.fields()).isEmpty();
    }

    @Test
    public void should_support_property_sets() {
        PropertyDefinition def = PropertyDefinition.builder((String)"hello").name("Hello").fields(PropertyFieldDefinition.build((String)"first").name("First").description("Description").options(new String[]{"A", "B"}).build(), new PropertyFieldDefinition[]{PropertyFieldDefinition.build((String)"second").name("Second").type(PropertyType.INTEGER).indicativeSize(5).build()}).build();
        Assertions.assertThat((Comparable)def.type()).isEqualTo((Object)PropertyType.PROPERTY_SET);
        Assertions.assertThat((List)def.fields()).hasSize(2);
        Assertions.assertThat((String)((PropertyFieldDefinition)def.fields().get(0)).key()).isEqualTo((Object)"first");
        Assertions.assertThat((String)((PropertyFieldDefinition)def.fields().get(0)).name()).isEqualTo((Object)"First");
        Assertions.assertThat((String)((PropertyFieldDefinition)def.fields().get(0)).description()).isEqualTo((Object)"Description");
        Assertions.assertThat((Comparable)((PropertyFieldDefinition)def.fields().get(0)).type()).isEqualTo((Object)PropertyType.STRING);
        Assertions.assertThat((List)((PropertyFieldDefinition)def.fields().get(0)).options()).containsOnly((Object[])new String[]{"A", "B"});
        Assertions.assertThat((int)((PropertyFieldDefinition)def.fields().get(0)).indicativeSize()).isEqualTo(20);
        Assertions.assertThat((String)((PropertyFieldDefinition)def.fields().get(1)).key()).isEqualTo((Object)"second");
        Assertions.assertThat((String)((PropertyFieldDefinition)def.fields().get(1)).name()).isEqualTo((Object)"Second");
        Assertions.assertThat((Comparable)((PropertyFieldDefinition)def.fields().get(1)).type()).isEqualTo((Object)PropertyType.INTEGER);
        Assertions.assertThat((List)((PropertyFieldDefinition)def.fields().get(1)).options()).isEmpty();
        Assertions.assertThat((int)((PropertyFieldDefinition)def.fields().get(1)).indicativeSize()).isEqualTo(5);
    }

    @Test
    public void should_support_property_sets_from_annotation() {
        Properties props = (Properties)AnnotationUtils.getAnnotation(WithPropertySet.class, Properties.class);
        Property prop = props.value()[0];
        PropertyDefinition def = PropertyDefinition.create((Property)prop);
        Assertions.assertThat((Comparable)def.type()).isEqualTo((Object)PropertyType.PROPERTY_SET);
        Assertions.assertThat((List)def.fields()).hasSize(2);
        Assertions.assertThat((String)((PropertyFieldDefinition)def.fields().get(0)).key()).isEqualTo((Object)"first");
        Assertions.assertThat((String)((PropertyFieldDefinition)def.fields().get(0)).name()).isEqualTo((Object)"First");
        Assertions.assertThat((String)((PropertyFieldDefinition)def.fields().get(0)).description()).isEqualTo((Object)"Description");
        Assertions.assertThat((Comparable)((PropertyFieldDefinition)def.fields().get(0)).type()).isEqualTo((Object)PropertyType.STRING);
        Assertions.assertThat((List)((PropertyFieldDefinition)def.fields().get(0)).options()).containsOnly((Object[])new String[]{"A", "B"});
        Assertions.assertThat((int)((PropertyFieldDefinition)def.fields().get(0)).indicativeSize()).isEqualTo(20);
        Assertions.assertThat((String)((PropertyFieldDefinition)def.fields().get(1)).key()).isEqualTo((Object)"second");
        Assertions.assertThat((String)((PropertyFieldDefinition)def.fields().get(1)).name()).isEqualTo((Object)"Second");
        Assertions.assertThat((Comparable)((PropertyFieldDefinition)def.fields().get(1)).type()).isEqualTo((Object)PropertyType.INTEGER);
        Assertions.assertThat((List)((PropertyFieldDefinition)def.fields().get(1)).options()).isEmpty();
        Assertions.assertThat((int)((PropertyFieldDefinition)def.fields().get(1)).indicativeSize()).isEqualTo(5);
    }

    @Test
    public void should_validate_string() {
        PropertyDefinition def = PropertyDefinition.builder((String)"foo").name("foo").type(PropertyType.STRING).build();
        Assertions.assertThat((boolean)def.validate(null).isValid()).isTrue();
        Assertions.assertThat((boolean)def.validate("").isValid()).isTrue();
        Assertions.assertThat((boolean)def.validate("   ").isValid()).isTrue();
        Assertions.assertThat((boolean)def.validate("foo").isValid()).isTrue();
    }

    @Test
    public void should_validate_boolean() {
        PropertyDefinition def = PropertyDefinition.builder((String)"foo").name("foo").type(PropertyType.BOOLEAN).build();
        Assertions.assertThat((boolean)def.validate(null).isValid()).isTrue();
        Assertions.assertThat((boolean)def.validate("").isValid()).isTrue();
        Assertions.assertThat((boolean)def.validate("   ").isValid()).isTrue();
        Assertions.assertThat((boolean)def.validate("true").isValid()).isTrue();
        Assertions.assertThat((boolean)def.validate("false").isValid()).isTrue();
        Assertions.assertThat((boolean)def.validate("foo").isValid()).isFalse();
        Assertions.assertThat((String)def.validate("foo").getErrorKey()).isEqualTo((Object)"notBoolean");
    }

    @Test
    public void should_validate_integer() {
        PropertyDefinition def = PropertyDefinition.builder((String)"foo").name("foo").type(PropertyType.INTEGER).build();
        Assertions.assertThat((boolean)def.validate(null).isValid()).isTrue();
        Assertions.assertThat((boolean)def.validate("").isValid()).isTrue();
        Assertions.assertThat((boolean)def.validate("   ").isValid()).isTrue();
        Assertions.assertThat((boolean)def.validate("123456").isValid()).isTrue();
        Assertions.assertThat((boolean)def.validate("foo").isValid()).isFalse();
        Assertions.assertThat((String)def.validate("foo").getErrorKey()).isEqualTo((Object)"notInteger");
    }

    @Test
    public void validate_long() {
        PropertyDefinition def = PropertyDefinition.builder((String)"foo").name("foo").type(PropertyType.LONG).build();
        Assertions.assertThat((boolean)def.validate(null).isValid()).isTrue();
        Assertions.assertThat((boolean)def.validate("").isValid()).isTrue();
        Assertions.assertThat((boolean)def.validate("   ").isValid()).isTrue();
        Assertions.assertThat((boolean)def.validate("123456").isValid()).isTrue();
        Assertions.assertThat((boolean)def.validate("foo").isValid()).isFalse();
        Assertions.assertThat((String)def.validate("foo").getErrorKey()).isEqualTo((Object)"notInteger");
    }

    @Test
    public void should_validate_float() {
        PropertyDefinition def = PropertyDefinition.builder((String)"foo").name("foo").type(PropertyType.FLOAT).build();
        Assertions.assertThat((boolean)def.validate(null).isValid()).isTrue();
        Assertions.assertThat((boolean)def.validate("").isValid()).isTrue();
        Assertions.assertThat((boolean)def.validate("   ").isValid()).isTrue();
        Assertions.assertThat((boolean)def.validate("123456").isValid()).isTrue();
        Assertions.assertThat((boolean)def.validate("3.14").isValid()).isTrue();
        Assertions.assertThat((boolean)def.validate("foo").isValid()).isFalse();
        Assertions.assertThat((String)def.validate("foo").getErrorKey()).isEqualTo((Object)"notFloat");
    }

    @Test
    public void validate_regular_expression() {
        PropertyDefinition def = PropertyDefinition.builder((String)"foo").name("foo").type(PropertyType.REGULAR_EXPRESSION).build();
        Assertions.assertThat((boolean)def.validate(null).isValid()).isTrue();
        Assertions.assertThat((boolean)def.validate("").isValid()).isTrue();
        Assertions.assertThat((boolean)def.validate("   ").isValid()).isTrue();
        Assertions.assertThat((boolean)def.validate("[a-zA-Z]").isValid()).isTrue();
        Assertions.assertThat((boolean)def.validate("[a-zA-Z").isValid()).isFalse();
        Assertions.assertThat((String)def.validate("[a-zA-Z").getErrorKey()).isEqualTo((Object)"notRegexp");
    }

    @Test
    public void should_validate_single_select_list() {
        PropertyDefinition def = PropertyDefinition.builder((String)"foo").name("foo").type(PropertyType.SINGLE_SELECT_LIST).options("de", new String[]{"en"}).build();
        Assertions.assertThat((boolean)def.validate(null).isValid()).isTrue();
        Assertions.assertThat((boolean)def.validate("").isValid()).isTrue();
        Assertions.assertThat((boolean)def.validate("   ").isValid()).isTrue();
        Assertions.assertThat((boolean)def.validate("de").isValid()).isTrue();
        Assertions.assertThat((boolean)def.validate("en").isValid()).isTrue();
        Assertions.assertThat((boolean)def.validate("fr").isValid()).isFalse();
        Assertions.assertThat((String)def.validate("fr").getErrorKey()).isEqualTo((Object)"notInOptions");
    }

    @Test
    public void should_auto_detect_password_type() {
        PropertyDefinition def = PropertyDefinition.builder((String)"scm.password.secured").name("SCM password").build();
        Assertions.assertThat((String)def.key()).isEqualTo((Object)"scm.password.secured");
        Assertions.assertThat((Comparable)def.type()).isEqualTo((Object)PropertyType.PASSWORD);
    }

    @Test
    public void PropertyDef() {
        PropertyDefinition def = PropertyDefinition.builder((String)"views.license.secured").name("Views license").build();
        Assertions.assertThat((String)def.key()).isEqualTo((Object)"views.license.secured");
        Assertions.assertThat((Comparable)def.type()).isEqualTo((Object)PropertyType.LICENSE);
    }

    @Test
    public void should_not_authorise_empty_key() {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Key must be set");
        PropertyDefinition.builder(null).build();
    }

    @Test
    public void should_not_authorize_defining_on_qualifiers_and_hidden() {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Cannot be hidden and defining qualifiers on which to display");
        PropertyDefinition.builder((String)"foo").name("foo").onQualifiers("FIL", new String[0]).hidden().build();
    }

    @Test
    public void should_not_authorize_defining_ony_on_qualifiers_and_hidden() {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Cannot be hidden and defining qualifiers on which to display");
        PropertyDefinition.builder((String)"foo").name("foo").onlyOnQualifiers("FIL", new String[0]).hidden().build();
    }

    @Test
    public void should_not_authorize_defining_on_qualifiers_and_only_on_qualifiers() {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Cannot define both onQualifiers and onlyOnQualifiers");
        PropertyDefinition.builder((String)"foo").name("foo").onQualifiers("FIL", new String[0]).onlyOnQualifiers("TRK", new String[0]).build();
    }

    @Properties(value={@Property(key="hello", name="Hello")})
    static class DefaultValues {
        DefaultValues() {
        }
    }

    @Properties(value={@Property(key="hello", name="Hello", fields={@PropertyField(key="first", name="First", description="Description", options={"A", "B"}), @PropertyField(key="second", name="Second", type=PropertyType.INTEGER, indicativeSize=5)})})
    static class WithPropertySet {
        WithPropertySet() {
        }
    }

    @Properties(value={@Property(key="hello", name="Hello", defaultValue="world", description="desc", options={"de", "en"}, category="categ", type=PropertyType.FLOAT, global=false, project=true, module=true, multiValues=true, propertySetKey="set")})
    static class Init {
        Init() {
        }
    }
}

