/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.config;

import java.util.Date;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.assertj.core.data.Offset;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.sonar.api.Properties;
import org.sonar.api.Property;
import org.sonar.api.PropertyType;
import org.sonar.api.config.MapSettings;
import org.sonar.api.config.PropertyDefinitions;
import org.sonar.api.utils.DateUtils;

public class MapSettingsTest {
    private PropertyDefinitions definitions;
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Before
    public void init_definitions() {
        this.definitions = new PropertyDefinitions(new Object[0]);
        this.definitions.addComponent(Init.class);
    }

    @Test
    public void default_values_should_be_loaded_from_definitions() {
        MapSettings settings = new MapSettings(this.definitions);
        Assertions.assertThat((String)settings.getDefaultValue("hello")).isEqualTo((Object)"world");
    }

    @Test
    public void set_property_int() {
        MapSettings settings = new MapSettings();
        settings.setProperty("foo", Integer.valueOf(123));
        Assertions.assertThat((int)settings.getInt("foo")).isEqualTo(123);
        Assertions.assertThat((String)settings.getString("foo")).isEqualTo((Object)"123");
        Assertions.assertThat((boolean)settings.getBoolean("foo")).isFalse();
    }

    @Test
    public void default_number_values_are_zero() {
        MapSettings settings = new MapSettings();
        Assertions.assertThat((int)settings.getInt("foo")).isEqualTo(0);
        Assertions.assertThat((long)settings.getLong("foo")).isEqualTo(0L);
    }

    @Test
    public void getInt_value_must_be_valid() {
        this.thrown.expect(NumberFormatException.class);
        MapSettings settings = new MapSettings();
        settings.setProperty("foo", "not a number");
        settings.getInt("foo");
    }

    @Test
    public void all_values_should_be_trimmed_set_property() {
        MapSettings settings = new MapSettings();
        settings.setProperty("foo", "   FOO ");
        Assertions.assertThat((String)settings.getString("foo")).isEqualTo((Object)"FOO");
    }

    @Test
    public void test_get_default_value() {
        MapSettings settings = new MapSettings(this.definitions);
        Assertions.assertThat((String)settings.getDefaultValue("unknown")).isNull();
    }

    @Test
    public void test_get_string() {
        MapSettings settings = new MapSettings(this.definitions);
        settings.setProperty("hello", "Russia");
        Assertions.assertThat((String)settings.getString("hello")).isEqualTo((Object)"Russia");
    }

    @Test
    public void setProperty_date() {
        MapSettings settings = new MapSettings();
        Date date = DateUtils.parseDateTime((String)"2010-05-18T15:50:45+0100");
        settings.setProperty("aDate", date);
        settings.setProperty("aDateTime", date, true);
        Assertions.assertThat((String)settings.getString("aDate")).isEqualTo((Object)"2010-05-18");
        Assertions.assertThat((String)settings.getString("aDateTime")).startsWith((CharSequence)"2010-05-18T");
    }

    @Test
    public void test_get_date() {
        MapSettings settings = new MapSettings(this.definitions);
        Assertions.assertThat((Date)settings.getDate("unknown")).isNull();
        Assertions.assertThat((int)settings.getDate("date").getDate()).isEqualTo(18);
        Assertions.assertThat((int)settings.getDate("date").getMonth()).isEqualTo(4);
    }

    @Test
    public void test_get_date_not_found() {
        MapSettings settings = new MapSettings(this.definitions);
        Assertions.assertThat((Date)settings.getDate("unknown")).isNull();
    }

    @Test
    public void test_get_datetime() {
        MapSettings settings = new MapSettings(this.definitions);
        Assertions.assertThat((Date)settings.getDateTime("unknown")).isNull();
        Assertions.assertThat((int)settings.getDateTime("datetime").getDate()).isEqualTo(18);
        Assertions.assertThat((int)settings.getDateTime("datetime").getMonth()).isEqualTo(4);
        Assertions.assertThat((int)settings.getDateTime("datetime").getMinutes()).isEqualTo(50);
    }

    @Test
    public void test_get_double() {
        MapSettings settings = new MapSettings();
        settings.setProperty("from_double", Double.valueOf(3.14159));
        settings.setProperty("from_string", "3.14159");
        Assertions.assertThat((Double)settings.getDouble("from_double")).isEqualTo(3.14159, Offset.offset((Number)1.0E-5));
        Assertions.assertThat((Double)settings.getDouble("from_string")).isEqualTo(3.14159, Offset.offset((Number)1.0E-5));
        Assertions.assertThat((Double)settings.getDouble("unknown")).isNull();
    }

    @Test
    public void test_get_float() {
        MapSettings settings = new MapSettings();
        settings.setProperty("from_float", Float.valueOf(3.14159f));
        settings.setProperty("from_string", "3.14159");
        Assertions.assertThat((Double)settings.getDouble("from_float")).isEqualTo((double)3.14159f, Offset.offset((Number)1.0E-5));
        Assertions.assertThat((Double)settings.getDouble("from_string")).isEqualTo((double)3.14159f, Offset.offset((Number)1.0E-5));
        Assertions.assertThat((Double)settings.getDouble("unknown")).isNull();
    }

    @Test
    public void test_get_bad_float() {
        MapSettings settings = new MapSettings();
        settings.setProperty("foo", "bar");
        this.thrown.expect(IllegalStateException.class);
        this.thrown.expectMessage("The property 'foo' is not a float value");
        settings.getFloat("foo");
    }

    @Test
    public void test_get_bad_double() {
        MapSettings settings = new MapSettings();
        settings.setProperty("foo", "bar");
        this.thrown.expect(IllegalStateException.class);
        this.thrown.expectMessage("The property 'foo' is not a double value");
        settings.getDouble("foo");
    }

    @Test
    public void testSetNullFloat() {
        MapSettings settings = new MapSettings();
        settings.setProperty("foo", (Float)null);
        Assertions.assertThat((Float)settings.getFloat("foo")).isNull();
    }

    @Test
    public void testSetNullDouble() {
        MapSettings settings = new MapSettings();
        settings.setProperty("foo", (Double)null);
        Assertions.assertThat((Double)settings.getDouble("foo")).isNull();
    }

    @Test
    public void getStringArray() {
        MapSettings settings = new MapSettings(this.definitions);
        Object[] array = settings.getStringArray("array");
        Assertions.assertThat((Object[])array).isEqualTo((Object)new String[]{"one", "two", "three"});
    }

    @Test
    public void setStringArray() {
        MapSettings settings = new MapSettings(this.definitions);
        settings.setProperty("multi_values", new String[]{"A", "B"});
        Object[] array = settings.getStringArray("multi_values");
        Assertions.assertThat((Object[])array).isEqualTo((Object)new String[]{"A", "B"});
    }

    @Test
    public void setStringArrayTrimValues() {
        MapSettings settings = new MapSettings(this.definitions);
        settings.setProperty("multi_values", new String[]{" A ", " B "});
        Object[] array = settings.getStringArray("multi_values");
        Assertions.assertThat((Object[])array).isEqualTo((Object)new String[]{"A", "B"});
    }

    @Test
    public void setStringArrayEscapeCommas() {
        MapSettings settings = new MapSettings(this.definitions);
        settings.setProperty("multi_values", new String[]{"A,B", "C,D"});
        Object[] array = settings.getStringArray("multi_values");
        Assertions.assertThat((Object[])array).isEqualTo((Object)new String[]{"A,B", "C,D"});
    }

    @Test
    public void setStringArrayWithEmptyValues() {
        MapSettings settings = new MapSettings(this.definitions);
        settings.setProperty("multi_values", new String[]{"A,B", "", "C,D"});
        Object[] array = settings.getStringArray("multi_values");
        Assertions.assertThat((Object[])array).isEqualTo((Object)new String[]{"A,B", "", "C,D"});
    }

    @Test
    public void setStringArrayWithNullValues() {
        MapSettings settings = new MapSettings(this.definitions);
        settings.setProperty("multi_values", new String[]{"A,B", null, "C,D"});
        Object[] array = settings.getStringArray("multi_values");
        Assertions.assertThat((Object[])array).isEqualTo((Object)new String[]{"A,B", "", "C,D"});
    }

    @Test(expected=IllegalStateException.class)
    public void shouldFailToSetArrayValueOnSingleValueProperty() {
        MapSettings settings = new MapSettings(this.definitions);
        settings.setProperty("array", new String[]{"A", "B", "C"});
    }

    @Test
    public void getStringArray_no_value() {
        MapSettings settings = new MapSettings();
        Object[] array = settings.getStringArray("array");
        Assertions.assertThat((Object[])array).isEmpty();
    }

    @Test
    public void shouldTrimArray() {
        MapSettings settings = new MapSettings();
        settings.setProperty("foo", "  one,  two, three  ");
        Object[] array = settings.getStringArray("foo");
        Assertions.assertThat((Object[])array).isEqualTo((Object)new String[]{"one", "two", "three"});
    }

    @Test
    public void shouldKeepEmptyValuesWhenSplitting() {
        MapSettings settings = new MapSettings();
        settings.setProperty("foo", "  one,  , two");
        Object[] array = settings.getStringArray("foo");
        Assertions.assertThat((Object[])array).isEqualTo((Object)new String[]{"one", "", "two"});
    }

    @Test
    public void testDefaultValueOfGetString() {
        MapSettings settings = new MapSettings(this.definitions);
        Assertions.assertThat((String)settings.getString("hello")).isEqualTo((Object)"world");
    }

    @Test
    public void set_property_boolean() {
        MapSettings settings = new MapSettings();
        settings.setProperty("foo", Boolean.valueOf(true));
        settings.setProperty("bar", Boolean.valueOf(false));
        Assertions.assertThat((boolean)settings.getBoolean("foo")).isTrue();
        Assertions.assertThat((boolean)settings.getBoolean("bar")).isFalse();
        Assertions.assertThat((String)settings.getString("foo")).isEqualTo((Object)"true");
        Assertions.assertThat((String)settings.getString("bar")).isEqualTo((Object)"false");
    }

    @Test
    public void ignore_case_of_boolean_values() {
        MapSettings settings = new MapSettings();
        settings.setProperty("foo", "true");
        settings.setProperty("bar", "TRUE");
        settings.setProperty("baz", "True");
        Assertions.assertThat((boolean)settings.getBoolean("foo")).isTrue();
        Assertions.assertThat((boolean)settings.getBoolean("bar")).isTrue();
        Assertions.assertThat((boolean)settings.getBoolean("baz")).isTrue();
    }

    @Test
    public void get_boolean() {
        MapSettings settings = new MapSettings(this.definitions);
        Assertions.assertThat((boolean)settings.getBoolean("boolean")).isTrue();
        Assertions.assertThat((boolean)settings.getBoolean("falseboolean")).isFalse();
        Assertions.assertThat((boolean)settings.getBoolean("unknown")).isFalse();
        Assertions.assertThat((boolean)settings.getBoolean("hello")).isFalse();
    }

    @Test
    public void shouldCreateByIntrospectingComponent() {
        MapSettings settings = new MapSettings();
        settings.getDefinitions().addComponent(MyComponent.class);
        Assertions.assertThat((String)settings.getDefaultValue("foo")).isEqualTo((Object)"bar");
    }

    @Test
    public void getStringLines_no_value() {
        Assertions.assertThat((Object[])new MapSettings().getStringLines("foo")).hasSize(0);
    }

    @Test
    public void getStringLines_single_line() {
        MapSettings settings = new MapSettings();
        settings.setProperty("foo", "the line");
        Assertions.assertThat((Object[])settings.getStringLines("foo")).isEqualTo((Object)new String[]{"the line"});
    }

    @Test
    public void getStringLines_linux() {
        MapSettings settings = new MapSettings();
        settings.setProperty("foo", "one\ntwo");
        Assertions.assertThat((Object[])settings.getStringLines("foo")).isEqualTo((Object)new String[]{"one", "two"});
        settings.setProperty("foo", "one\ntwo\n");
        Assertions.assertThat((Object[])settings.getStringLines("foo")).isEqualTo((Object)new String[]{"one", "two"});
    }

    @Test
    public void getStringLines_windows() {
        MapSettings settings = new MapSettings();
        settings.setProperty("foo", "one\r\ntwo");
        Assertions.assertThat((Object[])settings.getStringLines("foo")).isEqualTo((Object)new String[]{"one", "two"});
        settings.setProperty("foo", "one\r\ntwo\r\n");
        Assertions.assertThat((Object[])settings.getStringLines("foo")).isEqualTo((Object)new String[]{"one", "two"});
    }

    @Test
    public void getStringLines_mix() {
        MapSettings settings = new MapSettings();
        settings.setProperty("foo", "one\r\ntwo\nthree");
        Assertions.assertThat((Object[])settings.getStringLines("foo")).isEqualTo((Object)new String[]{"one", "two", "three"});
    }

    @Test
    public void getKeysStartingWith() {
        MapSettings settings = new MapSettings();
        settings.setProperty("sonar.jdbc.url", "foo");
        settings.setProperty("sonar.jdbc.username", "bar");
        settings.setProperty("sonar.security", "admin");
        Assertions.assertThat((List)settings.getKeysStartingWith("sonar")).containsOnly((Object[])new String[]{"sonar.jdbc.url", "sonar.jdbc.username", "sonar.security"});
        Assertions.assertThat((List)settings.getKeysStartingWith("sonar.jdbc")).containsOnly((Object[])new String[]{"sonar.jdbc.url", "sonar.jdbc.username"});
        Assertions.assertThat((List)settings.getKeysStartingWith("other")).hasSize(0);
    }

    @Test
    public void should_fallback_deprecated_key_to_default_value_of_new_key() {
        MapSettings settings = new MapSettings(this.definitions);
        Assertions.assertThat((String)settings.getString("newKeyWithDefaultValue")).isEqualTo((Object)"default_value");
        Assertions.assertThat((String)settings.getString("oldKeyWithDefaultValue")).isEqualTo((Object)"default_value");
    }

    @Test
    public void should_fallback_deprecated_key_to_new_key() {
        MapSettings settings = new MapSettings(this.definitions);
        settings.setProperty("newKey", "value of newKey");
        Assertions.assertThat((String)settings.getString("newKey")).isEqualTo((Object)"value of newKey");
        Assertions.assertThat((String)settings.getString("oldKey")).isEqualTo((Object)"value of newKey");
    }

    @Test
    public void should_load_value_of_deprecated_key() {
        MapSettings settings = new MapSettings(this.definitions);
        settings.setProperty("oldKey", "value of oldKey");
        Assertions.assertThat((String)settings.getString("newKey")).isEqualTo((Object)"value of oldKey");
        Assertions.assertThat((String)settings.getString("oldKey")).isEqualTo((Object)"value of oldKey");
    }

    @Test
    public void should_load_values_of_deprecated_key() {
        MapSettings settings = new MapSettings(this.definitions);
        settings.setProperty("oldKey", "a,b");
        Assertions.assertThat((Object[])settings.getStringArray("newKey")).containsOnly((Object[])new String[]{"a", "b"});
        Assertions.assertThat((Object[])settings.getStringArray("oldKey")).containsOnly((Object[])new String[]{"a", "b"});
    }

    @Test
    public void should_support_deprecated_props_with_multi_values() {
        MapSettings settings = new MapSettings(this.definitions);
        settings.setProperty("new_multi_values", new String[]{" A ", " B "});
        Assertions.assertThat((Object[])settings.getStringArray("new_multi_values")).isEqualTo((Object)new String[]{"A", "B"});
        Assertions.assertThat((Object[])settings.getStringArray("old_multi_values")).isEqualTo((Object)new String[]{"A", "B"});
    }

    @Property(key="foo", name="Foo", defaultValue="bar")
    public static class MyComponent {
    }

    @Properties(value={@Property(key="hello", name="Hello", defaultValue="world"), @Property(key="date", name="Date", defaultValue="2010-05-18"), @Property(key="datetime", name="DateTime", defaultValue="2010-05-18T15:50:45+0100"), @Property(key="boolean", name="Boolean", defaultValue="true"), @Property(key="falseboolean", name="False Boolean", defaultValue="false"), @Property(key="integer", name="Integer", defaultValue="12345"), @Property(key="array", name="Array", defaultValue="one,two,three"), @Property(key="multi_values", name="Array", defaultValue="1,2,3", multiValues=true), @Property(key="sonar.jira", name="Jira Server", type=PropertyType.PROPERTY_SET, propertySetKey="jira"), @Property(key="newKey", name="New key", deprecatedKey="oldKey"), @Property(key="newKeyWithDefaultValue", name="New key with default value", deprecatedKey="oldKeyWithDefaultValue", defaultValue="default_value"), @Property(key="new_multi_values", name="New multi values", defaultValue="1,2,3", multiValues=true, deprecatedKey="old_multi_values")})
    private static class Init {
        private Init() {
        }
    }
}

