/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.config;

import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.apache.commons.codec.binary.Base64;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.sonar.api.config.License;
import org.sonar.api.utils.DateUtils;

public class LicenseTest {
    private static final String V2_FORMAT = "Foo: bar\nOrganisation: ABC \nServer: 12345   \nProduct: SQALE\n  Expiration: 2012-05-18  \nType:  EVALUATION   \nOther: field\n";
    private static final String V1_FORMAT = "Foo: bar\nName: ABC \nPlugin: SQALE\n  Expires: 2012-05-18  \nOther: field\nDigest: abcdef\nObeo: obeo\n";

    @Test
    public void readPlainTest() {
        License license = License.readPlainText((String)V2_FORMAT);
        Assertions.assertThat((String)license.getOrganization()).isEqualTo((Object)"ABC");
        Assertions.assertThat((String)license.getServer()).isEqualTo((Object)"12345");
        Assertions.assertThat((String)license.getProduct()).isEqualTo((Object)"SQALE");
        Assertions.assertThat((String)license.getExpirationDateAsString()).isEqualTo((Object)"2012-05-18");
        Assertions.assertThat((String)license.getType()).isEqualTo((Object)"EVALUATION");
    }

    @Test
    public void readPlainText_empty_fields() {
        License license = License.readPlainText((String)"");
        Assertions.assertThat((String)license.getOrganization()).isNull();
        Assertions.assertThat((String)license.getServer()).isNull();
        Assertions.assertThat((String)license.getProduct()).isNull();
        Assertions.assertThat((String)license.getExpirationDateAsString()).isNull();
        Assertions.assertThat((Date)license.getExpirationDate()).isNull();
        Assertions.assertThat((String)license.getType()).isNull();
    }

    @Test
    public void readPlainText_not_valid_input() {
        License license = License.readPlainText((String)"old pond ... a frog leaps in water\u2019s sound");
        Assertions.assertThat((String)license.getOrganization()).isNull();
        Assertions.assertThat((String)license.getServer()).isNull();
        Assertions.assertThat((String)license.getProduct()).isNull();
        Assertions.assertThat((String)license.getExpirationDateAsString()).isNull();
        Assertions.assertThat((Date)license.getExpirationDate()).isNull();
        Assertions.assertThat((String)license.getType()).isNull();
    }

    @Test
    public void readPlainTest_version_1() {
        License license = License.readPlainText((String)V1_FORMAT);
        Assertions.assertThat((String)license.getOrganization()).isEqualTo((Object)"ABC");
        Assertions.assertThat((String)license.getServer()).isNull();
        Assertions.assertThat((String)license.getProduct()).isEqualTo((Object)"SQALE");
        Assertions.assertThat((String)license.getExpirationDateAsString()).isEqualTo((Object)"2012-05-18");
        Assertions.assertThat((String)license.getType()).isNull();
    }

    @Test
    public void readBase64() {
        License license = License.readBase64((String)new String(Base64.encodeBase64((byte[])V2_FORMAT.getBytes())));
        Assertions.assertThat((String)license.getOrganization()).isEqualTo((Object)"ABC");
        Assertions.assertThat((String)license.getServer()).isEqualTo((Object)"12345");
        Assertions.assertThat((String)license.getProduct()).isEqualTo((Object)"SQALE");
        Assertions.assertThat((String)license.getExpirationDateAsString()).isEqualTo((Object)"2012-05-18");
        Assertions.assertThat((String)license.getType()).isEqualTo((Object)"EVALUATION");
    }

    @Test
    public void trimBeforeReadingBase64() {
        String encodedKeyWithTrailingWhiteSpaces = "Rm9vOiBiYXIKT3JnYW5pc2F0aW9uOiBBQkMgClNlcnZlcjogMTIzND  \nUgICAKUHJvZHVjdDogU1FBTEUKICBFeHBpcmF0aW9uOiAyMDEyLTA1    \nLTE4ICAKVHlwZTogIEVWQUxVQVRJT04gICAKT3RoZXI6IGZpZWxkCg==\n";
        License license = License.readBase64((String)new String(encodedKeyWithTrailingWhiteSpaces.getBytes()));
        Assertions.assertThat((String)license.getOrganization()).isEqualTo((Object)"ABC");
        Assertions.assertThat((String)license.getServer()).isEqualTo((Object)"12345");
        Assertions.assertThat((String)license.getProduct()).isEqualTo((Object)"SQALE");
        Assertions.assertThat((String)license.getExpirationDateAsString()).isEqualTo((Object)"2012-05-18");
        Assertions.assertThat((String)license.getType()).isEqualTo((Object)"EVALUATION");
    }

    @Test
    public void readBase64_not_base64() {
        License license = License.readBase64((String)"\u00e7\u00e9 '123$@");
        Assertions.assertThat((String)license.getOrganization()).isNull();
        Assertions.assertThat((String)license.getServer()).isNull();
        Assertions.assertThat((String)license.getProduct()).isNull();
        Assertions.assertThat((String)license.getExpirationDateAsString()).isNull();
        Assertions.assertThat((Date)license.getExpirationDate()).isNull();
        Assertions.assertThat((String)license.getType()).isNull();
    }

    @Test
    public void isExpired() {
        License license = License.readPlainText((String)V2_FORMAT);
        Assertions.assertThat((boolean)license.isExpired(DateUtils.parseDate((String)"2011-01-01"))).isFalse();
        Calendar sameDay = Calendar.getInstance(TimeZone.getDefault());
        sameDay.setTime(DateUtils.parseDate((String)"2012-05-18"));
        Assertions.assertThat((boolean)license.isExpired(sameDay.getTime())).isFalse();
        sameDay.set(11, 15);
        Assertions.assertThat((boolean)license.isExpired(sameDay.getTime())).isFalse();
        sameDay.set(11, 23);
        sameDay.set(12, 59);
        sameDay.set(13, 59);
        Assertions.assertThat((boolean)license.isExpired(sameDay.getTime())).isFalse();
        sameDay.add(13, 1);
        Assertions.assertThat((boolean)license.isExpired(sameDay.getTime())).isTrue();
        Assertions.assertThat((boolean)license.isExpired(DateUtils.parseDate((String)"2013-06-23"))).isTrue();
    }

    @Test
    public void otherProperties() {
        License license = License.readPlainText((String)V2_FORMAT);
        Assertions.assertThat((String)((String)license.additionalProperties().get("Other"))).isEqualTo((Object)"field");
        Assertions.assertThat((boolean)license.additionalProperties().containsKey("Digest")).isFalse();
        Assertions.assertThat((boolean)license.additionalProperties().containsKey("Obeo")).isFalse();
    }
}

