/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.config;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.sonar.api.config.Encryption;

public class EncryptionTest {
    @Test
    public void isEncrypted() {
        Encryption encryption = new Encryption(null);
        Assert.assertThat((Object)encryption.isEncrypted("{aes}ADASDASAD"), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)encryption.isEncrypted("{b64}ADASDASAD"), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)encryption.isEncrypted("{abc}ADASDASAD"), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)encryption.isEncrypted("{}"), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)encryption.isEncrypted("{foo"), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)encryption.isEncrypted("foo{aes}"), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void scramble() {
        Encryption encryption = new Encryption(null);
        Assert.assertThat((Object)encryption.scramble("foo"), (Matcher)Matchers.is((Object)"{b64}Zm9v"));
    }

    @Test
    public void decrypt() {
        Encryption encryption = new Encryption(null);
        Assert.assertThat((Object)encryption.decrypt("{b64}Zm9v"), (Matcher)Matchers.is((Object)"foo"));
    }

    @Test
    public void decrypt_unknown_algorithm() {
        Encryption encryption = new Encryption(null);
        Assert.assertThat((Object)encryption.decrypt("{xxx}Zm9v"), (Matcher)Matchers.is((Object)"{xxx}Zm9v"));
    }

    @Test
    public void decrypt_uncrypted_text() {
        Encryption encryption = new Encryption(null);
        Assert.assertThat((Object)encryption.decrypt("foo"), (Matcher)Matchers.is((Object)"foo"));
    }
}

