/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.config;

import java.io.File;
import java.net.URL;
import java.security.InvalidKeyException;
import java.security.Key;
import javax.crypto.BadPaddingException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.sonar.api.config.AesCipher;

public class AesCipherTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void generateRandomSecretKey() {
        AesCipher cipher = new AesCipher(null);
        String key = cipher.generateRandomSecretKey();
        Assert.assertThat((Object)StringUtils.isNotBlank((String)key), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)Base64.isArrayByteBase64((byte[])key.getBytes()), (Matcher)Is.is((Object)true));
    }

    @Test
    public void encrypt() throws Exception {
        AesCipher cipher = new AesCipher(this.pathToSecretKey());
        String encryptedText = cipher.encrypt("this is a secret");
        Assert.assertThat((Object)StringUtils.isNotBlank((String)encryptedText), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)Base64.isArrayByteBase64((byte[])encryptedText.getBytes()), (Matcher)Is.is((Object)true));
    }

    @Test
    public void encrypt_bad_key() throws Exception {
        this.thrown.expect(RuntimeException.class);
        this.thrown.expectMessage("Invalid AES key");
        URL resource = this.getClass().getResource("/org/sonar/api/config/AesCipherTest/bad_secret_key.txt");
        AesCipher cipher = new AesCipher(new File(resource.toURI()).getCanonicalPath());
        cipher.encrypt("this is a secret");
    }

    @Test
    public void decrypt() throws Exception {
        AesCipher cipher = new AesCipher(this.pathToSecretKey());
        String clearText = cipher.decrypt("9mx5Zq4JVyjeChTcVjEide4kWCwusFl7P2dSVXtg9IY=");
        Assert.assertThat((Object)clearText, (Matcher)Is.is((Object)"this is a secret"));
    }

    @Test
    public void decrypt_bad_key() throws Exception {
        URL resource = this.getClass().getResource("/org/sonar/api/config/AesCipherTest/bad_secret_key.txt");
        AesCipher cipher = new AesCipher(new File(resource.toURI()).getCanonicalPath());
        try {
            cipher.decrypt("9mx5Zq4JVyjeChTcVjEide4kWCwusFl7P2dSVXtg9IY=");
            Assert.fail();
        }
        catch (RuntimeException e) {
            Assert.assertThat((Object)e.getCause(), (Matcher)Matchers.instanceOf(InvalidKeyException.class));
        }
    }

    @Test
    public void decrypt_other_key() throws Exception {
        URL resource = this.getClass().getResource("/org/sonar/api/config/AesCipherTest/other_secret_key.txt");
        AesCipher cipher = new AesCipher(new File(resource.toURI()).getCanonicalPath());
        try {
            cipher.decrypt("9mx5Zq4JVyjeChTcVjEide4kWCwusFl7P2dSVXtg9IY=");
            Assert.fail();
        }
        catch (RuntimeException e) {
            Assert.assertThat((Object)e.getCause(), (Matcher)Matchers.instanceOf(BadPaddingException.class));
        }
    }

    @Test
    public void encryptThenDecrypt() throws Exception {
        AesCipher cipher = new AesCipher(this.pathToSecretKey());
        Assert.assertThat((Object)cipher.decrypt(cipher.encrypt("foo")), (Matcher)Is.is((Object)"foo"));
    }

    @Test
    public void testDefaultPathToSecretKey() {
        AesCipher cipher = new AesCipher(null);
        String path = cipher.getPathToSecretKey();
        Assert.assertThat((Object)StringUtils.isNotBlank((String)path), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)new File(path).getName(), (Matcher)Is.is((Object)"sonar-secret.txt"));
    }

    @Test
    public void loadSecretKeyFromFile() throws Exception {
        AesCipher cipher = new AesCipher(null);
        Key secretKey = cipher.loadSecretFileFromFile(this.pathToSecretKey());
        Assert.assertThat((Object)secretKey.getAlgorithm(), (Matcher)Is.is((Object)"AES"));
        Assert.assertThat((Object)secretKey.getEncoded().length, (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(10)));
    }

    @Test
    public void loadSecretKeyFromFile_trim_content() throws Exception {
        URL resource = this.getClass().getResource("/org/sonar/api/config/AesCipherTest/non_trimmed_secret_key.txt");
        String path = new File(resource.toURI()).getCanonicalPath();
        AesCipher cipher = new AesCipher(null);
        Key secretKey = cipher.loadSecretFileFromFile(path);
        Assert.assertThat((Object)secretKey.getAlgorithm(), (Matcher)Is.is((Object)"AES"));
        Assert.assertThat((Object)secretKey.getEncoded().length, (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(10)));
    }

    @Test
    public void loadSecretKeyFromFile_file_does_not_exist() throws Exception {
        this.thrown.expect(IllegalStateException.class);
        AesCipher cipher = new AesCipher(null);
        cipher.loadSecretFileFromFile("/file/does/not/exist");
    }

    @Test
    public void loadSecretKeyFromFile_no_property() throws Exception {
        this.thrown.expect(IllegalStateException.class);
        AesCipher cipher = new AesCipher(null);
        cipher.loadSecretFileFromFile(null);
    }

    @Test
    public void hasSecretKey() throws Exception {
        AesCipher cipher = new AesCipher(this.pathToSecretKey());
        Assert.assertThat((Object)cipher.hasSecretKey(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void doesNotHaveSecretKey() {
        AesCipher cipher = new AesCipher("/my/twitter/id/is/SimonBrandhof");
        Assert.assertThat((Object)cipher.hasSecretKey(), (Matcher)Matchers.is((Object)false));
    }

    private String pathToSecretKey() throws Exception {
        URL resource = this.getClass().getResource("/org/sonar/api/config/AesCipherTest/aes_secret_key.txt");
        return new File(resource.toURI()).getCanonicalPath();
    }
}

