/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.ce.posttask;

import org.assertj.core.api.Assertions;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.sonar.api.ce.posttask.PostProjectAnalysisTaskTester;
import org.sonar.api.ce.posttask.QualityGate;

public class QualityGateBuilder_PostProjectAnalysisTaskTesterTest {
    private static final String SOME_NAME = "some name";
    private static final QualityGate.Status SOME_STATUS = QualityGate.Status.ERROR;
    private static final String SOME_ID = "some id";
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private QualityGate.Condition condition1 = (QualityGate.Condition)Mockito.mock(QualityGate.Condition.class);
    private QualityGate.Condition condition2 = (QualityGate.Condition)Mockito.mock(QualityGate.Condition.class);
    private PostProjectAnalysisTaskTester.QualityGateBuilder underTest = PostProjectAnalysisTaskTester.newQualityGateBuilder();

    @Test
    public void setId_throws_NPE_if_id_is_null() {
        this.expectedException.expect(NullPointerException.class);
        this.expectedException.expectMessage("id cannot be null");
        this.underTest.setId(null);
    }

    @Test
    public void setStatus_throws_NPE_if_status_is_null() {
        this.expectedException.expect(NullPointerException.class);
        this.expectedException.expectMessage("status cannot be null");
        this.underTest.setStatus(null);
    }

    @Test
    public void setName_throws_NPE_if_name_is_null() {
        this.expectedException.expect(NullPointerException.class);
        this.expectedException.expectMessage("name cannot be null");
        this.underTest.setName(null);
    }

    @Test
    public void addCondition_throws_NPE_if_condition_is_null() {
        this.expectedException.expect(NullPointerException.class);
        this.expectedException.expectMessage("condition cannot be null");
        this.underTest.add(null);
    }

    @Test
    public void clearConditions_does_not_raise_any_error_if_there_is_no_condition_in_builder() {
        this.underTest.clearConditions();
    }

    @Test
    public void clearConditions_removes_all_conditions_from_builder() {
        this.underTest.setId(SOME_ID).setStatus(SOME_STATUS).setName(SOME_NAME).add(this.condition1).add(this.condition2);
        Assertions.assertThat((Iterable)this.underTest.build().getConditions()).containsOnly((Object[])new QualityGate.Condition[]{this.condition1, this.condition2});
        this.underTest.clearConditions();
        Assertions.assertThat((Iterable)this.underTest.build().getConditions()).isEmpty();
    }

    @Test
    public void build_throws_NPE_if_id_is_null() {
        this.underTest.setStatus(SOME_STATUS).setName(SOME_NAME);
        this.expectedException.expect(NullPointerException.class);
        this.expectedException.expectMessage("id cannot be null");
        this.underTest.build();
    }

    @Test
    public void build_throws_NPE_if_status_is_null() {
        this.underTest.setId(SOME_ID).setName(SOME_NAME);
        this.expectedException.expect(NullPointerException.class);
        this.expectedException.expectMessage("status cannot be null");
        this.underTest.build();
    }

    @Test
    public void build_throws_NPE_if_name_is_null() {
        this.underTest.setId(SOME_ID).setStatus(SOME_STATUS);
        this.expectedException.expect(NullPointerException.class);
        this.expectedException.expectMessage("name cannot be null");
        this.underTest.build();
    }

    @Test
    public void build_returns_new_instance_at_each_call() {
        this.underTest.setId(SOME_ID).setStatus(SOME_STATUS).setName(SOME_NAME);
        Assertions.assertThat((Object)this.underTest.build()).isNotSameAs((Object)this.underTest.build());
    }

    @Test
    public void verify_getters() {
        QualityGate qualityGate = this.underTest.setId(SOME_ID).setStatus(SOME_STATUS).setName(SOME_NAME).add(this.condition1).add(this.condition2).build();
        Assertions.assertThat((String)qualityGate.getId()).isEqualTo((Object)SOME_ID);
        Assertions.assertThat((Comparable)qualityGate.getStatus()).isEqualTo((Object)SOME_STATUS);
        Assertions.assertThat((String)qualityGate.getName()).isEqualTo((Object)SOME_NAME);
        Assertions.assertThat((Iterable)qualityGate.getConditions()).containsOnly((Object[])new QualityGate.Condition[]{this.condition1, this.condition2});
    }

    @Test
    public void verify_toString() {
        Mockito.when((Object)this.condition1.toString()).thenReturn((Object)"condition1");
        Mockito.when((Object)this.condition2.toString()).thenReturn((Object)"condition2");
        Assertions.assertThat((String)this.underTest.setId(SOME_ID).setStatus(SOME_STATUS).setName(SOME_NAME).add(this.condition1).add(this.condition2).build().toString()).isEqualTo((Object)"QualityGate{id='some id', name='some name', status=ERROR, conditions=[condition1, condition2]}");
    }
}

