/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.ce.posttask;

import org.assertj.core.api.Assertions;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.sonar.api.ce.posttask.PostProjectAnalysisTaskTester;
import org.sonar.api.ce.posttask.Project;

public class ProjectBuilder_PostProjectAnalysisTaskTesterTest {
    private static final String SOME_NAME = "some name";
    private static final String SOME_KEY = "some key";
    private static final String SOME_UUID = "some uuid";
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private PostProjectAnalysisTaskTester.ProjectBuilder underTest = PostProjectAnalysisTaskTester.newProjectBuilder();

    @Test
    public void setKey_throws_NPE_if_key_is_null() {
        this.expectedException.expect(NullPointerException.class);
        this.expectedException.expectMessage("key cannot be null");
        this.underTest.setKey(null);
    }

    @Test
    public void setName_throws_NPE_if_name_is_null() {
        this.expectedException.expect(NullPointerException.class);
        this.expectedException.expectMessage("name cannot be null");
        this.underTest.setName(null);
    }

    @Test
    public void setUuid_throws_NPE_if_uuid_is_null() {
        this.expectedException.expect(NullPointerException.class);
        this.expectedException.expectMessage("uuid cannot be null");
        this.underTest.setUuid(null);
    }

    @Test
    public void build_throws_NPE_if_key_is_null() {
        this.underTest.setUuid(SOME_UUID).setName(SOME_NAME);
        this.expectedException.expect(NullPointerException.class);
        this.expectedException.expectMessage("key cannot be null");
        this.underTest.build();
    }

    @Test
    public void build_throws_NPE_if_name_is_null() {
        this.underTest.setUuid(SOME_UUID).setKey(SOME_KEY);
        this.expectedException.expect(NullPointerException.class);
        this.expectedException.expectMessage("name cannot be null");
        this.underTest.build();
    }

    @Test
    public void build_throws_NPE_if_uuid_is_null() {
        this.underTest.setKey(SOME_KEY).setName(SOME_NAME);
        this.expectedException.expect(NullPointerException.class);
        this.expectedException.expectMessage("uuid cannot be null");
        this.underTest.build();
    }

    @Test
    public void build_returns_new_instance_at_each_call() {
        this.underTest.setUuid(SOME_UUID).setKey(SOME_KEY).setName(SOME_NAME);
        Assertions.assertThat((Object)this.underTest.build()).isNotSameAs((Object)this.underTest.build());
    }

    @Test
    public void verify_getters() {
        Project project = this.underTest.setUuid(SOME_UUID).setKey(SOME_KEY).setName(SOME_NAME).build();
        Assertions.assertThat((String)project.getUuid()).isEqualTo((Object)SOME_UUID);
        Assertions.assertThat((String)project.getKey()).isEqualTo((Object)SOME_KEY);
        Assertions.assertThat((String)project.getName()).isEqualTo((Object)SOME_NAME);
    }

    @Test
    public void verify_toString() {
        Assertions.assertThat((String)this.underTest.setUuid(SOME_UUID).setKey(SOME_KEY).setName(SOME_NAME).build().toString()).isEqualTo((Object)"Project{uuid='some uuid', key='some key', name='some name'}");
    }
}

