/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.ce.posttask;

import java.util.Date;
import org.assertj.core.api.Assertions;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.sonar.api.ce.posttask.CeTask;
import org.sonar.api.ce.posttask.PostProjectAnalysisTask;
import org.sonar.api.ce.posttask.PostProjectAnalysisTaskTester;
import org.sonar.api.ce.posttask.Project;
import org.sonar.api.ce.posttask.QualityGate;

public class PostProjectAnalysisTaskTesterTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private CeTask ceTask = (CeTask)Mockito.mock(CeTask.class);
    private Project project = (Project)Mockito.mock(Project.class);
    private long someDateAsLong = 846351351684351L;
    private Date someDate = new Date(this.someDateAsLong);
    private QualityGate qualityGate = (QualityGate)Mockito.mock(QualityGate.class);
    private CaptorPostProjectAnalysisTask captorPostProjectAnalysisTask = new CaptorPostProjectAnalysisTask();
    private PostProjectAnalysisTaskTester underTest = PostProjectAnalysisTaskTester.of((PostProjectAnalysisTask)this.captorPostProjectAnalysisTask);

    @Test
    public void of_throws_NPE_if_PostProjectAnalysisTask_is_null() {
        this.expectedException.expect(NullPointerException.class);
        this.expectedException.expectMessage("PostProjectAnalysisTask instance cannot be null");
        PostProjectAnalysisTaskTester.of(null);
    }

    @Test
    public void withCeTask_throws_NPE_if_ceTask_is_null() {
        this.expectedException.expect(NullPointerException.class);
        this.expectedException.expectMessage("ceTask cannot be null");
        this.underTest.withCeTask(null);
    }

    @Test
    public void withProject_throws_NPE_if_project_is_null() {
        this.expectedException.expect(NullPointerException.class);
        this.expectedException.expectMessage("project cannot be null");
        this.underTest.withProject(null);
    }

    @Test
    public void at_throws_NPE_if_date_is_null() {
        this.expectedException.expect(NullPointerException.class);
        this.expectedException.expectMessage("date cannot be null");
        this.underTest.at(null);
    }

    @Test
    public void withQualityGate_does_not_throw_NPE_if_project_is_null() {
        this.underTest.withQualityGate(null);
    }

    @Test
    public void execute_throws_NPE_if_ceTask_is_null() {
        this.underTest.withProject(this.project).at(this.someDate);
        this.expectedException.expect(NullPointerException.class);
        this.expectedException.expectMessage("ceTask cannot be null");
        this.underTest.execute();
    }

    @Test
    public void execute_throws_NPE_if_project_is_null() {
        this.underTest.withCeTask(this.ceTask).at(this.someDate);
        this.expectedException.expect(NullPointerException.class);
        this.expectedException.expectMessage("project cannot be null");
        this.underTest.execute();
    }

    @Test
    public void verify_getters_of_ProjectAnalysis_object_passed_to_PostProjectAnalysisTask() {
        this.underTest.withCeTask(this.ceTask).withProject(this.project).withQualityGate(this.qualityGate).at(this.someDate);
        this.underTest.execute();
        PostProjectAnalysisTask.ProjectAnalysis projectAnalysis = this.captorPostProjectAnalysisTask.projectAnalysis;
        Assertions.assertThat((Object)projectAnalysis).isNotNull();
        Assertions.assertThat((Object)projectAnalysis.getCeTask()).isSameAs((Object)this.ceTask);
        Assertions.assertThat((Object)projectAnalysis.getProject()).isSameAs((Object)this.project);
        Assertions.assertThat((Date)projectAnalysis.getDate()).isSameAs((Object)this.someDate);
        Assertions.assertThat((Object)projectAnalysis.getQualityGate()).isSameAs((Object)this.qualityGate);
    }

    @Test
    public void verify_toString_of_ProjectAnalysis_object_passed_to_PostProjectAnalysisTask() {
        Mockito.when((Object)this.ceTask.toString()).thenReturn((Object)"CeTask");
        Mockito.when((Object)this.project.toString()).thenReturn((Object)"Project");
        Mockito.when((Object)this.qualityGate.toString()).thenReturn((Object)"QualityGate");
        this.underTest.withCeTask(this.ceTask).withProject(this.project).withQualityGate(this.qualityGate).at(this.someDate);
        this.underTest.execute();
        Assertions.assertThat((String)this.captorPostProjectAnalysisTask.projectAnalysis.toString()).isEqualTo((Object)"ProjectAnalysis{ceTask=CeTask, project=Project, date=846351351684351, analysisDate=846351351684351, qualityGate=QualityGate}");
    }

    @Test
    public void execute_throws_NPE_if_date_is_null() {
        this.underTest.withCeTask(this.ceTask).withProject(this.project);
        this.expectedException.expect(NullPointerException.class);
        this.expectedException.expectMessage("date cannot be null");
        this.underTest.execute();
    }

    private static class CaptorPostProjectAnalysisTask
    implements PostProjectAnalysisTask {
        private PostProjectAnalysisTask.ProjectAnalysis projectAnalysis;

        private CaptorPostProjectAnalysisTask() {
        }

        public void finished(PostProjectAnalysisTask.ProjectAnalysis analysis) {
            this.projectAnalysis = analysis;
        }
    }
}

