/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.ce.posttask;

import org.assertj.core.api.Assertions;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.sonar.api.ce.posttask.PostProjectAnalysisTaskTester;
import org.sonar.api.ce.posttask.QualityGate;

public class ConditionBuilder_PostProjectAnalysisTaskTesterTest {
    private static final String SOME_METRIC_KEY = "some metric key";
    private static final QualityGate.Operator SOME_OPERATOR = QualityGate.Operator.GREATER_THAN;
    private static final String SOME_ERROR_THRESHOLD = "some error threshold";
    private static final String SOME_WARNING_THRESHOLD = "some warning threshold";
    private static final QualityGate.EvaluationStatus SOME_STATUS_BUT_NO_VALUE = QualityGate.EvaluationStatus.OK;
    private static final String SOME_VALUE = "some value";
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private PostProjectAnalysisTaskTester.ConditionBuilder underTest = PostProjectAnalysisTaskTester.newConditionBuilder();

    @Test
    public void setMetricKey_throws_NPE_if_operator_is_null() {
        this.expectedException.expect(NullPointerException.class);
        this.expectedException.expectMessage("metricKey cannot be null");
        this.underTest.setMetricKey(null);
    }

    @Test
    public void setOperator_throws_NPE_if_operator_is_null() {
        this.expectedException.expect(NullPointerException.class);
        this.expectedException.expectMessage("operator cannot be null");
        this.underTest.setOperator(null);
    }

    @Test
    public void buildNoValue_throws_NPE_if_metricKey_is_null() {
        this.underTest.setOperator(SOME_OPERATOR).setErrorThreshold(SOME_ERROR_THRESHOLD).setWarningThreshold(SOME_WARNING_THRESHOLD);
        this.expectedException.expect(NullPointerException.class);
        this.expectedException.expectMessage("metricKey cannot be null");
        this.underTest.buildNoValue();
    }

    @Test
    public void buildNoValue_throws_NPE_if_operator_is_null() {
        this.underTest.setMetricKey(SOME_METRIC_KEY).setErrorThreshold(SOME_ERROR_THRESHOLD).setWarningThreshold(SOME_WARNING_THRESHOLD);
        this.expectedException.expect(NullPointerException.class);
        this.expectedException.expectMessage("operator cannot be null");
        this.underTest.buildNoValue();
    }

    @Test
    public void buildNoValue_throws_ISE_if_both_warningThreshold_and_errorThreshold_are_null() {
        this.underTest.setMetricKey(SOME_METRIC_KEY).setOperator(SOME_OPERATOR);
        this.expectedException.expect(IllegalStateException.class);
        this.expectedException.expectMessage("At least one of errorThreshold and warningThreshold must be non null");
        this.underTest.buildNoValue();
    }

    @Test
    public void buildNoValue_returns_Condition_which_getStatus_method_returns_NO_VALUE() {
        this.initValidBuilder();
        Assertions.assertThat((Comparable)this.underTest.buildNoValue().getStatus()).isEqualTo((Object)QualityGate.EvaluationStatus.NO_VALUE);
    }

    @Test
    public void buildNoValue_returns_Condition_which_getValue_method_throws_ISE() {
        this.initValidBuilder();
        QualityGate.Condition condition = this.underTest.buildNoValue();
        this.expectedException.expect(IllegalStateException.class);
        this.expectedException.expectMessage("There is no value when status is NO_VALUE");
        condition.getValue();
    }

    @Test
    public void buildNoValue_does_not_fail_when_only_errorThreshold_is_set() {
        this.underTest.setMetricKey(SOME_METRIC_KEY).setOperator(SOME_OPERATOR).setErrorThreshold(SOME_ERROR_THRESHOLD);
        this.underTest.buildNoValue();
    }

    @Test
    public void buildNoValue_does_not_fail_when_only_wardThreshold_is_set() {
        this.underTest.setMetricKey(SOME_METRIC_KEY).setOperator(SOME_OPERATOR).setWarningThreshold(SOME_WARNING_THRESHOLD);
        this.underTest.buildNoValue();
    }

    @Test
    public void buildNoValue_returns_new_instance_at_each_call() {
        this.initValidBuilder();
        Assertions.assertThat((Object)this.underTest.buildNoValue()).isNotSameAs((Object)this.underTest.buildNoValue());
    }

    @Test
    public void buildNoValue_has_no_value_in_toString_and_status_is_NO_VALUE() {
        this.initValidBuilder();
        Assertions.assertThat((String)this.underTest.buildNoValue().toString()).isEqualTo((Object)"Condition{status=NO_VALUE, metricKey='some metric key', operator=GREATER_THAN, errorThreshold='some error threshold', warningThreshold='some warning threshold', onLeakPeriod=false}");
    }

    @Test
    public void verify_getters_of_object_returned_by_buildNoValue() {
        this.initValidBuilder().setOnLeakPeriod(true);
        QualityGate.Condition condition = this.underTest.buildNoValue();
        Assertions.assertThat((String)condition.getMetricKey()).isEqualTo((Object)SOME_METRIC_KEY);
        Assertions.assertThat((Comparable)condition.getOperator()).isEqualTo((Object)SOME_OPERATOR);
        Assertions.assertThat((String)condition.getErrorThreshold()).isEqualTo((Object)SOME_ERROR_THRESHOLD);
        Assertions.assertThat((String)condition.getWarningThreshold()).isEqualTo((Object)SOME_WARNING_THRESHOLD);
        Assertions.assertThat((boolean)condition.isOnLeakPeriod()).isTrue();
    }

    @Test
    public void build_throws_NPE_if_status_is_null() {
        this.initValidBuilder();
        this.expectedException.expect(NullPointerException.class);
        this.expectedException.expectMessage("status cannot be null");
        this.underTest.build(null, SOME_VALUE);
    }

    @Test
    public void build_throws_IAE_if_status_is_NO_VALUE() {
        this.initValidBuilder();
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("status cannot be NO_VALUE, use method buildNoValue() instead");
        this.underTest.build(QualityGate.EvaluationStatus.NO_VALUE, SOME_VALUE);
    }

    @Test
    public void build_throws_NPE_if_value_is_null() {
        this.initValidBuilder();
        this.expectedException.expect(NullPointerException.class);
        this.expectedException.expectMessage("value cannot be null, use method buildNoValue() instead");
        this.underTest.build(SOME_STATUS_BUT_NO_VALUE, null);
    }

    @Test
    public void build_throws_NPE_if_metricKey_is_null() {
        this.underTest.setOperator(SOME_OPERATOR).setErrorThreshold(SOME_ERROR_THRESHOLD).setWarningThreshold(SOME_WARNING_THRESHOLD);
        this.expectedException.expect(NullPointerException.class);
        this.expectedException.expectMessage("metricKey cannot be null");
        this.underTest.build(SOME_STATUS_BUT_NO_VALUE, SOME_VALUE);
    }

    @Test
    public void build_throws_NPE_if_operator_is_null() {
        this.underTest.setMetricKey(SOME_METRIC_KEY).setErrorThreshold(SOME_ERROR_THRESHOLD).setWarningThreshold(SOME_WARNING_THRESHOLD);
        this.expectedException.expect(NullPointerException.class);
        this.expectedException.expectMessage("operator cannot be null");
        this.underTest.build(SOME_STATUS_BUT_NO_VALUE, SOME_VALUE);
    }

    @Test
    public void build_does_not_fail_when_only_errorThreshold_is_set() {
        this.underTest.setMetricKey(SOME_METRIC_KEY).setOperator(SOME_OPERATOR).setErrorThreshold(SOME_ERROR_THRESHOLD);
        this.underTest.build(SOME_STATUS_BUT_NO_VALUE, SOME_VALUE);
    }

    @Test
    public void build_does_not_fail_when_only_wardThreshold_is_set() {
        this.underTest.setMetricKey(SOME_METRIC_KEY).setOperator(SOME_OPERATOR).setWarningThreshold(SOME_WARNING_THRESHOLD);
        this.underTest.build(SOME_STATUS_BUT_NO_VALUE, SOME_VALUE);
    }

    @Test
    public void build_throws_ISE_if_both_warningThreshold_and_errorThreshold_are_null() {
        this.underTest.setMetricKey(SOME_METRIC_KEY).setOperator(SOME_OPERATOR);
        this.expectedException.expect(IllegalStateException.class);
        this.expectedException.expectMessage("At least one of errorThreshold and warningThreshold must be non null");
        this.underTest.build(SOME_STATUS_BUT_NO_VALUE, SOME_VALUE);
    }

    @Test
    public void build_returns_new_instance_at_each_call() {
        this.initValidBuilder();
        Assertions.assertThat((Object)this.underTest.build(SOME_STATUS_BUT_NO_VALUE, SOME_VALUE)).isNotSameAs((Object)this.underTest.build(SOME_STATUS_BUT_NO_VALUE, SOME_VALUE));
    }

    @Test
    public void build_has_value_in_toString_and_specified_status() {
        this.initValidBuilder();
        Assertions.assertThat((String)this.underTest.build(SOME_STATUS_BUT_NO_VALUE, SOME_VALUE).toString()).isEqualTo((Object)"Condition{status=OK, metricKey='some metric key', operator=GREATER_THAN, errorThreshold='some error threshold', warningThreshold='some warning threshold', onLeakPeriod=false, value='some value'}");
    }

    @Test
    public void build_returns_Condition_which_getStatus_method_returns_NO_VALUE() {
        this.initValidBuilder();
        Assertions.assertThat((Comparable)this.underTest.buildNoValue().getStatus()).isEqualTo((Object)QualityGate.EvaluationStatus.NO_VALUE);
    }

    @Test
    public void build_returns_Condition_which_getValue_method_throws_ISE() {
        this.initValidBuilder();
        QualityGate.Condition condition = this.underTest.buildNoValue();
        this.expectedException.expect(IllegalStateException.class);
        this.expectedException.expectMessage("There is no value when status is NO_VALUE");
        condition.getValue();
    }

    @Test
    public void verify_getters_of_object_returned_by_build() {
        this.initValidBuilder().setOnLeakPeriod(true);
        QualityGate.Condition condition = this.underTest.build(SOME_STATUS_BUT_NO_VALUE, SOME_VALUE);
        Assertions.assertThat((Comparable)condition.getStatus()).isEqualTo((Object)SOME_STATUS_BUT_NO_VALUE);
        Assertions.assertThat((String)condition.getMetricKey()).isEqualTo((Object)SOME_METRIC_KEY);
        Assertions.assertThat((Comparable)condition.getOperator()).isEqualTo((Object)SOME_OPERATOR);
        Assertions.assertThat((String)condition.getErrorThreshold()).isEqualTo((Object)SOME_ERROR_THRESHOLD);
        Assertions.assertThat((String)condition.getWarningThreshold()).isEqualTo((Object)SOME_WARNING_THRESHOLD);
        Assertions.assertThat((boolean)condition.isOnLeakPeriod()).isTrue();
        Assertions.assertThat((String)condition.getValue()).isEqualTo((Object)SOME_VALUE);
    }

    @Test
    public void isOnLeakPeriod_is_false_by_default() {
        this.initValidBuilder();
        Assertions.assertThat((boolean)this.underTest.buildNoValue().isOnLeakPeriod()).isFalse();
        Assertions.assertThat((boolean)this.underTest.build(SOME_STATUS_BUT_NO_VALUE, SOME_VALUE).isOnLeakPeriod()).isFalse();
    }

    @Test
    public void isOnLeakPeriod_changes_isOnLeakPeriod_returned_value() {
        this.initValidBuilder().setOnLeakPeriod(true);
        Assertions.assertThat((boolean)this.underTest.buildNoValue().isOnLeakPeriod()).isTrue();
        Assertions.assertThat((boolean)this.underTest.build(SOME_STATUS_BUT_NO_VALUE, SOME_VALUE).isOnLeakPeriod()).isTrue();
        this.initValidBuilder().setOnLeakPeriod(false);
        Assertions.assertThat((boolean)this.underTest.buildNoValue().isOnLeakPeriod()).isFalse();
        Assertions.assertThat((boolean)this.underTest.build(SOME_STATUS_BUT_NO_VALUE, SOME_VALUE).isOnLeakPeriod()).isFalse();
    }

    private PostProjectAnalysisTaskTester.ConditionBuilder initValidBuilder() {
        this.underTest.setMetricKey(SOME_METRIC_KEY).setOperator(SOME_OPERATOR).setErrorThreshold(SOME_ERROR_THRESHOLD).setWarningThreshold(SOME_WARNING_THRESHOLD);
        return this.underTest;
    }
}

