/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.ce.posttask;

import org.assertj.core.api.Assertions;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.sonar.api.ce.posttask.CeTask;
import org.sonar.api.ce.posttask.PostProjectAnalysisTaskTester;

public class CeTaskBuilder_PostProjectAnalysisTaskTesterTest {
    private static final CeTask.Status SOME_STATUS = CeTask.Status.SUCCESS;
    private static final String SOME_ID = "some id";
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private PostProjectAnalysisTaskTester.CeTaskBuilder underTest = PostProjectAnalysisTaskTester.newCeTaskBuilder();

    @Test
    public void setId_throws_NPE_if_id_is_null() {
        this.expectedException.expect(NullPointerException.class);
        this.expectedException.expectMessage("id cannot be null");
        this.underTest.setId(null);
    }

    @Test
    public void setStatus_throws_NPE_if_status_is_null() {
        this.expectedException.expect(NullPointerException.class);
        this.expectedException.expectMessage("status cannot be null");
        this.underTest.setStatus(null);
    }

    @Test
    public void build_throws_NPE_if_id_is_null() {
        this.underTest.setStatus(SOME_STATUS);
        this.expectedException.expect(NullPointerException.class);
        this.expectedException.expectMessage("id cannot be null");
        this.underTest.build();
    }

    @Test
    public void build_throws_NPE_if_status_is_null() {
        this.underTest.setId(SOME_ID);
        this.expectedException.expect(NullPointerException.class);
        this.expectedException.expectMessage("status cannot be null");
        this.underTest.build();
    }

    @Test
    public void build_returns_new_instance_at_each_call() {
        this.underTest.setId(SOME_ID).setStatus(SOME_STATUS);
        Assertions.assertThat((Object)this.underTest.build()).isNotSameAs((Object)this.underTest.build());
    }

    @Test
    public void verify_getters() {
        CeTask ceTask = this.underTest.setId(SOME_ID).setStatus(SOME_STATUS).build();
        Assertions.assertThat((String)ceTask.getId()).isEqualTo((Object)SOME_ID);
        Assertions.assertThat((Comparable)ceTask.getStatus()).isEqualTo((Object)SOME_STATUS);
    }

    @Test
    public void verify_toString() {
        Assertions.assertThat((String)this.underTest.setId(SOME_ID).setStatus(SOME_STATUS).build().toString()).isEqualTo((Object)"CeTask{id='some id', status=SUCCESS}");
    }
}

