/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.ce.measure.test;

import org.assertj.core.api.Assertions;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.sonar.api.ce.measure.test.TestMeasure;

public class TestMeasureTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void create_double_measure() throws Exception {
        Assertions.assertThat((double)TestMeasure.createMeasure((double)10.0).getDoubleValue()).isEqualTo(10.0);
    }

    @Test
    public void create_int_measure() throws Exception {
        Assertions.assertThat((int)TestMeasure.createMeasure((int)10).getIntValue()).isEqualTo(10);
    }

    @Test
    public void create_long_measure() throws Exception {
        Assertions.assertThat((long)TestMeasure.createMeasure((long)10L).getLongValue()).isEqualTo(10L);
    }

    @Test
    public void create_string_measure() throws Exception {
        Assertions.assertThat((String)TestMeasure.createMeasure((String)"value").getStringValue()).isEqualTo((Object)"value");
    }

    @Test
    public void create_boolean_measure() throws Exception {
        Assertions.assertThat((boolean)TestMeasure.createMeasure((boolean)true).getBooleanValue()).isTrue();
    }

    @Test
    public void getDoubleValue_fails_with_ISE_when_not_a_double() throws Exception {
        this.thrown.expect(IllegalStateException.class);
        this.thrown.expectMessage("Not a double measure");
        TestMeasure.createMeasure((int)10).getDoubleValue();
    }

    @Test
    public void getIntValue_fails_with_ISE_when_not_an_int() throws Exception {
        this.thrown.expect(IllegalStateException.class);
        this.thrown.expectMessage("Not an integer measure");
        TestMeasure.createMeasure((long)10L).getIntValue();
    }

    @Test
    public void getLongValue_fails_with_ISE_when_not_a_long() throws Exception {
        this.thrown.expect(IllegalStateException.class);
        this.thrown.expectMessage("Not a long measure");
        TestMeasure.createMeasure((int)10).getLongValue();
    }

    @Test
    public void getStringValue_fails_with_ISE_when_not_a_string() throws Exception {
        this.thrown.expect(IllegalStateException.class);
        this.thrown.expectMessage("Not a string measure");
        TestMeasure.createMeasure((int)10).getStringValue();
    }

    @Test
    public void getBooleanValue_fails_with_ISE_when_not_a_boolean() throws Exception {
        this.thrown.expect(IllegalStateException.class);
        this.thrown.expectMessage("Not a boolean measure");
        TestMeasure.createMeasure((int)10).getBooleanValue();
    }
}

