/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.ce.measure.test;

import org.assertj.core.api.Assertions;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.sonar.api.ce.measure.MeasureComputer;
import org.sonar.api.ce.measure.test.TestMeasureComputerDefinition;

public class TestMeasureComputerDefinitionTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void build_definition() throws Exception {
        MeasureComputer.MeasureComputerDefinition definition = new TestMeasureComputerDefinition.MeasureComputerDefinitionBuilderImpl().setInputMetrics(new String[]{"INPUT_1", "INPUT_2"}).setOutputMetrics(new String[]{"OUTPUT_1", "OUTPUT_2"}).build();
        Assertions.assertThat((Iterable)definition.getInputMetrics()).containsOnly((Object[])new String[]{"INPUT_1", "INPUT_2"});
        Assertions.assertThat((Iterable)definition.getOutputMetrics()).containsOnly((Object[])new String[]{"OUTPUT_1", "OUTPUT_2"});
    }

    @Test
    public void build_definition_without_input_metric() throws Exception {
        MeasureComputer.MeasureComputerDefinition definition = new TestMeasureComputerDefinition.MeasureComputerDefinitionBuilderImpl().setOutputMetrics(new String[]{"OUTPUT_1", "OUTPUT_2"}).build();
        Assertions.assertThat((Iterable)definition.getInputMetrics()).isEmpty();
        Assertions.assertThat((Iterable)definition.getOutputMetrics()).containsOnly((Object[])new String[]{"OUTPUT_1", "OUTPUT_2"});
    }

    @Test
    public void fail_with_NPE_when_building_definition_with_null_input_metrics() throws Exception {
        this.thrown.expect(NullPointerException.class);
        this.thrown.expectMessage("Input metrics cannot be null");
        new TestMeasureComputerDefinition.MeasureComputerDefinitionBuilderImpl().setInputMetrics(null).setOutputMetrics(new String[]{"OUTPUT_1", "OUTPUT_2"}).build();
    }

    @Test
    public void fail_with_NPE_when_building_definition_with_on_null_input_metric() throws Exception {
        this.thrown.expect(NullPointerException.class);
        this.thrown.expectMessage("Null metric is not allowed");
        new TestMeasureComputerDefinition.MeasureComputerDefinitionBuilderImpl().setInputMetrics(new String[]{"INPUT_1", null}).setOutputMetrics(new String[]{"OUTPUT_1", "OUTPUT_2"}).build();
    }

    @Test
    public void fail_with_NPE_when_building_definition_with_null_output_metrics() throws Exception {
        this.thrown.expect(NullPointerException.class);
        this.thrown.expectMessage("Output metrics cannot be null");
        new TestMeasureComputerDefinition.MeasureComputerDefinitionBuilderImpl().setInputMetrics(new String[]{"INPUT_1", "INPUT_2"}).setOutputMetrics(null).build();
    }

    @Test
    public void fail_with_NPE_when_building_definition_without_output_metrics() throws Exception {
        this.thrown.expect(NullPointerException.class);
        this.thrown.expectMessage("Output metrics cannot be null");
        new TestMeasureComputerDefinition.MeasureComputerDefinitionBuilderImpl().setInputMetrics(new String[]{"INPUT_1", "INPUT_2"}).build();
    }

    @Test
    public void fail_with_NPE_when_building_definition_with_on_null_ouput_metric() throws Exception {
        this.thrown.expect(NullPointerException.class);
        this.thrown.expectMessage("Null metric is not allowed");
        new TestMeasureComputerDefinition.MeasureComputerDefinitionBuilderImpl().setInputMetrics(new String[]{"INPUT_1", "INPUT_2"}).setOutputMetrics(new String[]{"OUTPUT_1", null}).build();
    }

    @Test
    public void fail_with_IAE_when_building_definition_with_empty_output_metrics() throws Exception {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("At least one output metric must be defined");
        new TestMeasureComputerDefinition.MeasureComputerDefinitionBuilderImpl().setInputMetrics(new String[]{"INPUT_1", "INPUT_2"}).setOutputMetrics(new String[0]).build();
    }

    @Test
    public void fail_with_IAE_when_building_definition_with_core_metrics_in_output_metrics() throws Exception {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Core metrics are not allowed");
        new TestMeasureComputerDefinition.MeasureComputerDefinitionBuilderImpl().setInputMetrics(new String[]{"INPUT_1", "INPUT_2"}).setOutputMetrics(new String[]{"ncloc"}).build();
    }
}

