/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.ce.measure.test;

import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.sonar.api.ce.measure.Component;
import org.sonar.api.ce.measure.Issue;
import org.sonar.api.ce.measure.MeasureComputer;
import org.sonar.api.ce.measure.Settings;
import org.sonar.api.ce.measure.test.TestComponent;
import org.sonar.api.ce.measure.test.TestIssue;
import org.sonar.api.ce.measure.test.TestMeasureComputerContext;
import org.sonar.api.ce.measure.test.TestMeasureComputerDefinition;
import org.sonar.api.ce.measure.test.TestSettings;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.rules.RuleType;
import org.sonar.api.utils.Duration;

public class TestMeasureComputerContextTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    static final String INPUT_METRIC = "INPUT_METRIC";
    static final String OUTPUT_METRIC = "OUTPUT_METRIC";
    static final Component PROJECT = new TestComponent("Project", Component.Type.PROJECT, null);
    static final MeasureComputer.MeasureComputerDefinition DEFINITION = new TestMeasureComputerDefinition.MeasureComputerDefinitionBuilderImpl().setInputMetrics(new String[]{"INPUT_METRIC"}).setOutputMetrics(new String[]{"OUTPUT_METRIC"}).build();
    Settings settings = new TestSettings();
    TestMeasureComputerContext underTest = new TestMeasureComputerContext(PROJECT, this.settings, DEFINITION);

    @Test
    public void get_component() throws Exception {
        Assertions.assertThat((Object)this.underTest.getComponent()).isEqualTo((Object)PROJECT);
    }

    @Test
    public void get_settings() throws Exception {
        Assertions.assertThat((Object)this.underTest.getSettings()).isEqualTo((Object)this.settings);
    }

    @Test
    public void get_int_measure() throws Exception {
        this.underTest.addInputMeasure(INPUT_METRIC, 10);
        Assertions.assertThat((int)this.underTest.getMeasure(INPUT_METRIC).getIntValue()).isEqualTo(10);
    }

    @Test
    public void get_double_measure() throws Exception {
        this.underTest.addInputMeasure(INPUT_METRIC, 10.0);
        Assertions.assertThat((double)this.underTest.getMeasure(INPUT_METRIC).getDoubleValue()).isEqualTo(10.0);
    }

    @Test
    public void get_long_measure() throws Exception {
        this.underTest.addInputMeasure(INPUT_METRIC, 10L);
        Assertions.assertThat((long)this.underTest.getMeasure(INPUT_METRIC).getLongValue()).isEqualTo(10L);
    }

    @Test
    public void get_string_measure() throws Exception {
        this.underTest.addInputMeasure(INPUT_METRIC, "text");
        Assertions.assertThat((String)this.underTest.getMeasure(INPUT_METRIC).getStringValue()).isEqualTo((Object)"text");
    }

    @Test
    public void get_boolean_measure() throws Exception {
        this.underTest.addInputMeasure(INPUT_METRIC, true);
        Assertions.assertThat((boolean)this.underTest.getMeasure(INPUT_METRIC).getBooleanValue()).isTrue();
    }

    @Test
    public void fail_with_IAE_when_trying_to_get_measure_on_unknown_metric() throws Exception {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Only metrics in [INPUT_METRIC] can be used to load measures");
        this.underTest.getMeasure("unknown");
    }

    @Test
    public void get_int_children_measures() throws Exception {
        this.underTest.addChildrenMeasures(INPUT_METRIC, new Integer[]{10, 20});
        Assertions.assertThat((Iterable)this.underTest.getChildrenMeasures(INPUT_METRIC)).hasSize(2);
    }

    @Test
    public void get_doublet_children_measures() throws Exception {
        this.underTest.addChildrenMeasures(INPUT_METRIC, new Double[]{10.0, 20.0});
        Assertions.assertThat((Iterable)this.underTest.getChildrenMeasures(INPUT_METRIC)).hasSize(2);
    }

    @Test
    public void get_long_children_measures() throws Exception {
        this.underTest.addChildrenMeasures(INPUT_METRIC, new Long[]{10L, 20L});
        Assertions.assertThat((Iterable)this.underTest.getChildrenMeasures(INPUT_METRIC)).hasSize(2);
    }

    @Test
    public void get_string_children_measures() throws Exception {
        this.underTest.addChildrenMeasures(INPUT_METRIC, new String[]{"value1", "value2"});
        Assertions.assertThat((Iterable)this.underTest.getChildrenMeasures(INPUT_METRIC)).hasSize(2);
    }

    @Test
    public void fail_with_IAE_when_trying_to_get_children_measures_on_unknown_metric() throws Exception {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Only metrics in [INPUT_METRIC] can be used to load measures");
        this.underTest.getChildrenMeasures("unknown");
    }

    @Test
    public void add_int_measure() throws Exception {
        this.underTest.addMeasure(OUTPUT_METRIC, 10);
        Assertions.assertThat((int)this.underTest.getMeasure(OUTPUT_METRIC).getIntValue()).isEqualTo(10);
    }

    @Test
    public void add_double_measure() throws Exception {
        this.underTest.addMeasure(OUTPUT_METRIC, 10.0);
        Assertions.assertThat((double)this.underTest.getMeasure(OUTPUT_METRIC).getDoubleValue()).isEqualTo(10.0);
    }

    @Test
    public void add_long_measure() throws Exception {
        this.underTest.addMeasure(OUTPUT_METRIC, 10L);
        Assertions.assertThat((long)this.underTest.getMeasure(OUTPUT_METRIC).getLongValue()).isEqualTo(10L);
    }

    @Test
    public void add_string_measure() throws Exception {
        this.underTest.addMeasure(OUTPUT_METRIC, "text");
        Assertions.assertThat((String)this.underTest.getMeasure(OUTPUT_METRIC).getStringValue()).isEqualTo((Object)"text");
    }

    @Test
    public void fail_with_IAE_when_trying_to_add_measure_on_unknown_metric() throws Exception {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Only metrics in [OUTPUT_METRIC] can be used to add measures. Metric 'unknown' is not allowed");
        this.underTest.addMeasure("unknown", 10);
    }

    @Test
    public void fail_with_IAE_when_trying_to_add_measure_on_input_metric() throws Exception {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Only metrics in [OUTPUT_METRIC] can be used to add measures. Metric 'INPUT_METRIC' is not allowed");
        this.underTest.addMeasure(INPUT_METRIC, 10);
    }

    @Test
    public void fail_with_UOE_when_trying_to_add_same_measures_twice() throws Exception {
        this.thrown.expect(UnsupportedOperationException.class);
        this.thrown.expectMessage("A measure on metric 'OUTPUT_METRIC' already exists");
        this.underTest.addMeasure(OUTPUT_METRIC, 10);
        this.underTest.addMeasure(OUTPUT_METRIC, 20);
    }

    @Test
    public void get_issues() throws Exception {
        Issue issue = new TestIssue.Builder().setKey("ABCD").setRuleKey(RuleKey.of((String)"xoo", (String)"S01")).setSeverity("BLOCKER").setStatus("RESOLVED").setResolution("FIXED").setDebt(Duration.create((long)10L)).setType(RuleType.BUG).build();
        this.underTest.setIssues(Arrays.asList(issue));
        Assertions.assertThat((List)this.underTest.getIssues()).hasSize(1);
    }
}

