/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.ce.measure.test;

import org.assertj.core.api.Assertions;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.sonar.api.ce.measure.Issue;
import org.sonar.api.ce.measure.test.TestIssue;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.rules.RuleType;
import org.sonar.api.utils.Duration;

public class TestIssueTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void create_issue() throws Exception {
        Issue issue = new TestIssue.Builder().setKey("ABCD").setRuleKey(RuleKey.of((String)"xoo", (String)"S01")).setSeverity("BLOCKER").setStatus("RESOLVED").setResolution("FIXED").setDebt(Duration.create((long)10L)).setType(RuleType.BUG).build();
        Assertions.assertThat((String)issue.key()).isEqualTo((Object)"ABCD");
        Assertions.assertThat((Comparable)issue.ruleKey()).isEqualTo((Object)RuleKey.of((String)"xoo", (String)"S01"));
        Assertions.assertThat((String)issue.severity()).isEqualTo((Object)"BLOCKER");
        Assertions.assertThat((String)issue.status()).isEqualTo((Object)"RESOLVED");
        Assertions.assertThat((String)issue.resolution()).isEqualTo((Object)"FIXED");
        Assertions.assertThat((Object)issue.debt()).isEqualTo((Object)Duration.create((long)10L));
    }

    @Test
    public void create_issue_with_minimal_fields() throws Exception {
        Issue issue = new TestIssue.Builder().setKey("ABCD").setRuleKey(RuleKey.of((String)"xoo", (String)"S01")).setSeverity("BLOCKER").setStatus("RESOLVED").setType(RuleType.BUG).build();
        Assertions.assertThat((String)issue.resolution()).isNull();
        Assertions.assertThat((Object)issue.debt()).isNull();
    }

    @Test
    public void fail_with_NPE_when_building_issue_without_key() throws Exception {
        this.thrown.expect(NullPointerException.class);
        this.thrown.expectMessage("key cannot be null");
        new TestIssue.Builder().setRuleKey(RuleKey.of((String)"xoo", (String)"S01")).setSeverity("BLOCKER").setStatus("RESOLVED").setResolution("FIXED").setType(RuleType.BUG).build();
    }

    @Test
    public void fail_with_NPE_when_creating_issue_with_null_key() throws Exception {
        this.thrown.expect(NullPointerException.class);
        this.thrown.expectMessage("key cannot be null");
        new TestIssue.Builder().setKey(null);
    }

    @Test
    public void fail_with_NPE_when_building_issue_without_rule_key() throws Exception {
        this.thrown.expect(NullPointerException.class);
        this.thrown.expectMessage("ruleKey cannot be null");
        new TestIssue.Builder().setKey("ABCD").setSeverity("BLOCKER").setStatus("RESOLVED").setResolution("FIXED").setType(RuleType.BUG).build();
    }

    @Test
    public void fail_with_NPE_when_creating_issue_with_null_rule_key() throws Exception {
        this.thrown.expect(NullPointerException.class);
        this.thrown.expectMessage("ruleKey cannot be null");
        new TestIssue.Builder().setRuleKey(null);
    }

    @Test
    public void fail_with_IAE_when_building_issue_with_invalid_resolution() throws Exception {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("resolution 'unknown' is invalid");
        new TestIssue.Builder().setKey("ABCD").setRuleKey(RuleKey.of((String)"xoo", (String)"S01")).setSeverity("BLOCKER").setStatus("RESOLVED").setResolution("unknown").setType(RuleType.BUG).build();
    }

    @Test
    public void fail_with_NPE_when_building_issue_without_severity() throws Exception {
        this.thrown.expect(NullPointerException.class);
        this.thrown.expectMessage("severity cannot be null");
        new TestIssue.Builder().setKey("ABCD").setRuleKey(RuleKey.of((String)"xoo", (String)"S01")).setStatus("RESOLVED").setResolution("FIXED").setType(RuleType.BUG).build();
    }

    @Test
    public void fail_with_NPE_when_creating_issue_with_null_severity() throws Exception {
        this.thrown.expect(NullPointerException.class);
        this.thrown.expectMessage("severity cannot be null");
        new TestIssue.Builder().setSeverity(null);
    }

    @Test
    public void fail_with_IAE_when_building_issue_with_invalid_severity() throws Exception {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("severity 'unknown' is invalid");
        new TestIssue.Builder().setKey("ABCD").setRuleKey(RuleKey.of((String)"xoo", (String)"S01")).setSeverity("unknown").setStatus("RESOLVED").setResolution("FIXED").setType(RuleType.BUG).build();
    }

    @Test
    public void fail_with_NPE_when_building_issue_without_status() throws Exception {
        this.thrown.expect(NullPointerException.class);
        this.thrown.expectMessage("status cannot be null");
        new TestIssue.Builder().setKey("ABCD").setRuleKey(RuleKey.of((String)"xoo", (String)"S01")).setSeverity("BLOCKER").setResolution("FIXED").setType(RuleType.BUG).build();
    }

    @Test
    public void fail_with_NPE_when_creating_issue_with_null_status() throws Exception {
        this.thrown.expect(NullPointerException.class);
        this.thrown.expectMessage("status cannot be null");
        new TestIssue.Builder().setStatus(null);
    }

    @Test
    public void fail_with_IAE_when_building_issue_with_invalid_status() throws Exception {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("status 'unknown' is invalid");
        new TestIssue.Builder().setKey("ABCD").setRuleKey(RuleKey.of((String)"xoo", (String)"S01")).setSeverity("BLOCKER").setStatus("unknown").setResolution("FIXED").setType(RuleType.BUG).build();
    }
}

