/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.ce.measure.test;

import org.assertj.core.api.Assertions;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.sonar.api.ce.measure.Component;
import org.sonar.api.ce.measure.test.TestComponent;

public class TestComponentTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void create_project() throws Exception {
        TestComponent component = new TestComponent("Project", Component.Type.PROJECT, null);
        Assertions.assertThat((String)component.getKey()).isEqualTo((Object)"Project");
        Assertions.assertThat((Comparable)component.getType()).isEqualTo((Object)Component.Type.PROJECT);
    }

    @Test
    public void create_source_file() throws Exception {
        TestComponent component = new TestComponent("File", Component.Type.FILE, (Component.FileAttributes)new TestComponent.FileAttributesImpl("xoo", false));
        Assertions.assertThat((Comparable)component.getType()).isEqualTo((Object)Component.Type.FILE);
        Assertions.assertThat((String)component.getFileAttributes().getLanguageKey()).isEqualTo((Object)"xoo");
        Assertions.assertThat((boolean)component.getFileAttributes().isUnitTest()).isFalse();
    }

    @Test
    public void create_test_file() throws Exception {
        TestComponent component = new TestComponent("File", Component.Type.FILE, (Component.FileAttributes)new TestComponent.FileAttributesImpl(null, true));
        Assertions.assertThat((Comparable)component.getType()).isEqualTo((Object)Component.Type.FILE);
        Assertions.assertThat((boolean)component.getFileAttributes().isUnitTest()).isTrue();
        Assertions.assertThat((String)component.getFileAttributes().getLanguageKey()).isNull();
    }

    @Test
    public void fail_with_ISE_when_calling_get_file_attributes_on_not_file() throws Exception {
        this.thrown.expect(IllegalStateException.class);
        this.thrown.expectMessage("Only component of type FILE have a FileAttributes object");
        TestComponent component = new TestComponent("Project", Component.Type.PROJECT, null);
        component.getFileAttributes();
    }

    @Test
    public void fail_with_IAE_when_trying_to_create_a_file_without_file_attributes() throws Exception {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("omponent of type FILE must have a FileAttributes object");
        new TestComponent("File", Component.Type.FILE, null);
    }

    @Test
    public void fail_with_IAE_when_trying_to_create_not_a_file_with_file_attributes() throws Exception {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Only component of type FILE have a FileAttributes object");
        new TestComponent("Project", Component.Type.PROJECT, (Component.FileAttributes)new TestComponent.FileAttributesImpl(null, true));
    }

    @Test
    public void fail_with_NPE_when_creating_component_without_key() throws Exception {
        this.thrown.expect(NullPointerException.class);
        this.thrown.expectMessage("Key cannot be null");
        new TestComponent(null, Component.Type.PROJECT, null);
    }

    @Test
    public void fail_with_NPE_when_creating_component_without_type() throws Exception {
        this.thrown.expect(NullPointerException.class);
        this.thrown.expectMessage("Type cannot be null");
        new TestComponent("Project", null, null);
    }

    @Test
    public void test_equals_and_hashcode() throws Exception {
        TestComponent component = new TestComponent("Project1", Component.Type.PROJECT, null);
        TestComponent sameComponent = new TestComponent("Project1", Component.Type.PROJECT, null);
        TestComponent anotherComponent = new TestComponent("Project2", Component.Type.PROJECT, null);
        Assertions.assertThat((Object)component).isEqualTo((Object)component);
        Assertions.assertThat((Object)component).isEqualTo((Object)sameComponent);
        Assertions.assertThat((Object)component).isNotEqualTo((Object)anotherComponent);
        Assertions.assertThat((Object)component).isNotEqualTo(null);
        Assertions.assertThat((int)component.hashCode()).isEqualTo(component.hashCode());
        Assertions.assertThat((int)component.hashCode()).isEqualTo(sameComponent.hashCode());
        Assertions.assertThat((int)component.hashCode()).isNotEqualTo(anotherComponent.hashCode());
    }

    @Test
    public void test_to_string() throws Exception {
        Assertions.assertThat((String)new TestComponent("File", Component.Type.FILE, (Component.FileAttributes)new TestComponent.FileAttributesImpl("xoo", true)).toString()).isEqualTo((Object)"ComponentImpl{key=File, type='FILE', fileAttributes=FileAttributesImpl{languageKey='xoo', unitTest=true}}");
    }
}

