/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.ce.measure;

import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.sonar.api.ce.measure.RangeDistributionBuilder;

public class RangeDistributionBuilderTest {
    @Test
    public void work_on_an_limits_array_copy() {
        Number[] limits = new Integer[]{4, 2, 0};
        RangeDistributionBuilder builder = new RangeDistributionBuilder(limits);
        builder.add((Number)3.2).add((Number)2.0).add((Number)6.2).build();
        Assertions.assertThat((Integer)limits[0]).isEqualTo(4);
        Assertions.assertThat((Integer)limits[1]).isEqualTo(2);
        Assertions.assertThat((Integer)limits[2]).isEqualTo(0);
    }

    @Test
    public void build_integer_distribution() {
        RangeDistributionBuilder builder = new RangeDistributionBuilder((Number[])new Integer[]{0, 2, 4});
        String data = builder.add((Number)3.2).add((Number)2.0).add((Number)6.2).build();
        Assertions.assertThat((String)data).isEqualTo((Object)"0=0;2=2;4=1");
    }

    @Test
    public void build_double_distribution() {
        RangeDistributionBuilder builder = new RangeDistributionBuilder((Number[])new Double[]{0.0, 2.0, 4.0});
        String data = builder.add((Number)3.2).add((Number)2.0).add((Number)6.2).build();
        Assertions.assertThat((String)data).isEqualTo((Object)"0=0;2=2;4=1");
    }

    @Test
    public void value_lesser_than_minimum_is_ignored() {
        RangeDistributionBuilder builder = new RangeDistributionBuilder((Number[])new Integer[]{0, 2, 4});
        String data = builder.add((Number)3.2).add((Number)2.0).add((Number)-3.0).build();
        Assertions.assertThat((String)data).isEqualTo((Object)"0=0;2=2;4=0");
    }

    @Test
    public void add_existing_integer_distribution() {
        RangeDistributionBuilder builder = new RangeDistributionBuilder();
        String data = builder.add("0=0;2=2;4=1").add("0=1;2=2;4=2").build();
        Assertions.assertThat((String)data).isEqualTo((Object)"0=1;2=4;4=3");
    }

    @Test
    public void add_existing_double_distribution() {
        RangeDistributionBuilder builder = new RangeDistributionBuilder();
        String data = builder.add("0.5=0;1.9=2;4.5=1").add("0.5=1;1.9=3;4.5=1").build();
        Assertions.assertThat((String)data).isEqualTo((Object)"0.5=1;1.9=5;4.5=2");
    }

    @Test
    public void add_distribution_with_identical_limits() {
        RangeDistributionBuilder builder = new RangeDistributionBuilder();
        String data = builder.add("0=1;2=0").add("0=3;2=5").build();
        Assertions.assertThat((String)data).isEqualTo((Object)"0=4;2=5");
    }

    @Test
    public void add_distribution_with_different_int_limits() {
        RangeDistributionBuilder builder = new RangeDistributionBuilder();
        Assertions.assertThat((String)builder.add("0=1").add("0=3;2=5").build()).isNull();
    }

    @Test
    public void add_distribution_with_different_double_limits() {
        RangeDistributionBuilder builder = new RangeDistributionBuilder();
        Assertions.assertThat((String)builder.add("0.0=3;3.0=5").add("0.0=3;3.0=5;6.0=9").build()).isNull();
    }

    @Test
    public void init_limits_at_the_first_add() {
        RangeDistributionBuilder builder = new RangeDistributionBuilder();
        String data = builder.add("0.5=3;3.5=5;6.5=9").add("0.5=0;3.5=2;6.5=1").build();
        Assertions.assertThat((String)data).isEqualTo((Object)"0.5=3;3.5=7;6.5=10");
    }

    @Test
    public void keep_int_ranges_when_merging_distributions() {
        RangeDistributionBuilder builder = new RangeDistributionBuilder();
        String data = builder.add("0=3;3=5;6=9").add("0=0;3=2;6=1").build();
        Assertions.assertThat((String)data).isEqualTo((Object)"0=3;3=7;6=10");
    }

    @Test
    public void is_empty_is_true_when_no_data() {
        RangeDistributionBuilder builder = new RangeDistributionBuilder();
        Assertions.assertThat((boolean)builder.isEmpty()).isTrue();
    }

    @Test
    public void is_empty_is_true_when_no_data_on_distribution_with_limits() {
        RangeDistributionBuilder builder = new RangeDistributionBuilder((Number[])new Integer[]{4, 2, 0});
        Assertions.assertThat((boolean)builder.isEmpty()).isTrue();
    }

    @Test
    public void aggregate_empty_distribution() {
        RangeDistributionBuilder builder = new RangeDistributionBuilder();
        String distribution = builder.build();
        Assertions.assertThat((String)distribution).isEmpty();
    }
}

