/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.sensor.symbol.internal;

import java.util.Map;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.TextRange;
import org.sonar.api.batch.fs.internal.TestInputFileBuilder;
import org.sonar.api.batch.sensor.internal.SensorStorage;
import org.sonar.api.batch.sensor.symbol.internal.DefaultSymbolTable;

public class DefaultSymbolTableTest {
    private static final InputFile INPUT_FILE = new TestInputFileBuilder("foo", "src/Foo.java").setLines(2).setOriginalLineOffsets(new int[]{0, 50}).setLastValidOffset(100).build();
    private Map<TextRange, Set<TextRange>> referencesPerSymbol;
    @Rule
    public ExpectedException throwable = ExpectedException.none();

    @Before
    public void setUpSampleSymbols() {
        DefaultSymbolTable symbolTableBuilder = new DefaultSymbolTable((SensorStorage)Mockito.mock(SensorStorage.class)).onFile(INPUT_FILE);
        symbolTableBuilder.newSymbol(0, 10).newReference(12, 15).newReference(2, 10, 2, 15);
        symbolTableBuilder.newSymbol(1, 12, 1, 15).newReference(52, 55);
        symbolTableBuilder.save();
        this.referencesPerSymbol = symbolTableBuilder.getReferencesBySymbol();
    }

    @Test
    public void should_register_symbols() {
        Assertions.assertThat(this.referencesPerSymbol).hasSize(2);
    }
}

