/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.sensor.measure.internal;

import java.io.Serializable;
import org.assertj.core.api.Assertions;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.internal.DefaultInputModule;
import org.sonar.api.batch.fs.internal.TestInputFileBuilder;
import org.sonar.api.batch.measure.Metric;
import org.sonar.api.batch.sensor.internal.SensorStorage;
import org.sonar.api.batch.sensor.measure.Measure;
import org.sonar.api.batch.sensor.measure.internal.DefaultMeasure;
import org.sonar.api.measures.CoreMetrics;

public class DefaultMeasureTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void build_file_measure() {
        SensorStorage storage = (SensorStorage)Mockito.mock(SensorStorage.class);
        DefaultMeasure newMeasure = new DefaultMeasure(storage).forMetric((Metric)CoreMetrics.LINES).on((InputComponent)new TestInputFileBuilder("foo", "src/Foo.php").build()).withValue((Serializable)Integer.valueOf(3));
        Assertions.assertThat((Object)newMeasure.inputComponent()).isEqualTo((Object)new TestInputFileBuilder("foo", "src/Foo.php").build());
        Assertions.assertThat((Object)newMeasure.metric()).isEqualTo((Object)CoreMetrics.LINES);
        Assertions.assertThat((Integer)((Integer)newMeasure.value())).isEqualTo(3);
        newMeasure.save();
        ((SensorStorage)Mockito.verify((Object)storage)).store((Measure)newMeasure);
    }

    @Test
    public void build_project_measure() {
        SensorStorage storage = (SensorStorage)Mockito.mock(SensorStorage.class);
        DefaultInputModule module = new DefaultInputModule("foo");
        DefaultMeasure newMeasure = new DefaultMeasure(storage).forMetric((Metric)CoreMetrics.LINES).on((InputComponent)module).withValue((Serializable)Integer.valueOf(3));
        Assertions.assertThat((Object)newMeasure.inputComponent()).isEqualTo((Object)new DefaultInputModule("foo"));
        Assertions.assertThat((Object)newMeasure.metric()).isEqualTo((Object)CoreMetrics.LINES);
        Assertions.assertThat((Integer)((Integer)newMeasure.value())).isEqualTo(3);
        newMeasure.save();
        ((SensorStorage)Mockito.verify((Object)storage)).store((Measure)newMeasure);
    }

    @Test
    public void not_allowed_to_call_on_twice() {
        this.thrown.expect(IllegalStateException.class);
        this.thrown.expectMessage("on() already called");
        new DefaultMeasure().on((InputComponent)new DefaultInputModule("foo")).on((InputComponent)new TestInputFileBuilder("foo", "src/Foo.php").build()).withValue((Serializable)Integer.valueOf(3)).save();
    }
}

