/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.sensor.issue.internal;

import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.mockito.Mockito;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.internal.DefaultInputDir;
import org.sonar.api.batch.fs.internal.DefaultInputFile;
import org.sonar.api.batch.fs.internal.DefaultInputModule;
import org.sonar.api.batch.fs.internal.TestInputFileBuilder;
import org.sonar.api.batch.rule.Severity;
import org.sonar.api.batch.sensor.internal.SensorStorage;
import org.sonar.api.batch.sensor.issue.Issue;
import org.sonar.api.batch.sensor.issue.NewIssueLocation;
import org.sonar.api.batch.sensor.issue.internal.DefaultIssue;
import org.sonar.api.batch.sensor.issue.internal.DefaultIssueLocation;
import org.sonar.api.rule.RuleKey;

public class DefaultIssueTest {
    private DefaultInputFile inputFile = new TestInputFileBuilder("foo", "src/Foo.php").initMetadata("Foo\nBar\n").build();

    @Test
    public void build_file_issue() {
        SensorStorage storage = (SensorStorage)Mockito.mock(SensorStorage.class);
        DefaultIssue issue = new DefaultIssue(storage).at((NewIssueLocation)new DefaultIssueLocation().on((InputComponent)this.inputFile).at(this.inputFile.selectLine(1)).message("Wrong way!")).forRule(RuleKey.of((String)"repo", (String)"rule")).gap(Double.valueOf(10.0));
        Assertions.assertThat((Object)issue.primaryLocation().inputComponent()).isEqualTo((Object)this.inputFile);
        Assertions.assertThat((Comparable)issue.ruleKey()).isEqualTo((Object)RuleKey.of((String)"repo", (String)"rule"));
        Assertions.assertThat((int)issue.primaryLocation().textRange().start().line()).isEqualTo(1);
        Assertions.assertThat((Double)issue.gap()).isEqualTo(10.0);
        Assertions.assertThat((String)issue.primaryLocation().message()).isEqualTo((Object)"Wrong way!");
        issue.save();
        ((SensorStorage)Mockito.verify((Object)storage)).store((Issue)issue);
    }

    @Test
    public void build_directory_issue() {
        SensorStorage storage = (SensorStorage)Mockito.mock(SensorStorage.class);
        DefaultIssue issue = new DefaultIssue(storage).at((NewIssueLocation)new DefaultIssueLocation().on((InputComponent)new DefaultInputDir("foo", "src")).message("Wrong way!")).forRule(RuleKey.of((String)"repo", (String)"rule")).overrideSeverity(Severity.BLOCKER);
        Assertions.assertThat((Object)issue.primaryLocation().inputComponent()).isEqualTo((Object)new DefaultInputDir("foo", "src"));
        Assertions.assertThat((Comparable)issue.ruleKey()).isEqualTo((Object)RuleKey.of((String)"repo", (String)"rule"));
        Assertions.assertThat((Object)issue.primaryLocation().textRange()).isNull();
        Assertions.assertThat((String)issue.primaryLocation().message()).isEqualTo((Object)"Wrong way!");
        Assertions.assertThat((Comparable)issue.overriddenSeverity()).isEqualTo((Object)Severity.BLOCKER);
        issue.save();
        ((SensorStorage)Mockito.verify((Object)storage)).store((Issue)issue);
    }

    @Test
    public void build_project_issue() {
        SensorStorage storage = (SensorStorage)Mockito.mock(SensorStorage.class);
        DefaultIssue issue = new DefaultIssue(storage).at((NewIssueLocation)new DefaultIssueLocation().on((InputComponent)new DefaultInputModule("foo")).message("Wrong way!")).forRule(RuleKey.of((String)"repo", (String)"rule")).effortToFix(Double.valueOf(10.0));
        Assertions.assertThat((Object)issue.primaryLocation().inputComponent()).isEqualTo((Object)new DefaultInputModule("foo"));
        Assertions.assertThat((Comparable)issue.ruleKey()).isEqualTo((Object)RuleKey.of((String)"repo", (String)"rule"));
        Assertions.assertThat((Object)issue.primaryLocation().textRange()).isNull();
        Assertions.assertThat((Double)issue.effortToFix()).isEqualTo(10.0);
        Assertions.assertThat((String)issue.primaryLocation().message()).isEqualTo((Object)"Wrong way!");
        issue.save();
        ((SensorStorage)Mockito.verify((Object)storage)).store((Issue)issue);
    }
}

