/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.sensor.issue.internal;

import org.apache.commons.lang.StringUtils;
import org.assertj.core.api.Assertions;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.internal.TestInputFileBuilder;
import org.sonar.api.batch.sensor.issue.internal.DefaultIssueLocation;

public class DefaultIssueLocationTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    private InputFile inputFile = new TestInputFileBuilder("foo", "src/Foo.php").initMetadata("Foo\nBar\n").build();

    @Test
    public void not_allowed_to_call_on_twice() {
        this.thrown.expect(IllegalStateException.class);
        this.thrown.expectMessage("on() already called");
        new DefaultIssueLocation().on((InputComponent)this.inputFile).on((InputComponent)this.inputFile).message("Wrong way!");
    }

    @Test
    public void prevent_too_long_messages() {
        Assertions.assertThat((String)new DefaultIssueLocation().on((InputComponent)this.inputFile).message(StringUtils.repeat((String)"a", (int)4000)).message()).hasSize(4000);
        Assertions.assertThat((String)new DefaultIssueLocation().on((InputComponent)this.inputFile).message(StringUtils.repeat((String)"a", (int)4001)).message()).hasSize(4000);
    }
}

