/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.sensor.internal;

import java.io.File;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.assertj.core.data.MapEntry;
import org.assertj.core.groups.Tuple;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.TextPointer;
import org.sonar.api.batch.fs.internal.DefaultFileSystem;
import org.sonar.api.batch.fs.internal.DefaultInputFile;
import org.sonar.api.batch.fs.internal.DefaultInputModule;
import org.sonar.api.batch.fs.internal.DefaultTextPointer;
import org.sonar.api.batch.fs.internal.TestInputFileBuilder;
import org.sonar.api.batch.measure.Metric;
import org.sonar.api.batch.rule.ActiveRules;
import org.sonar.api.batch.rule.internal.ActiveRulesBuilder;
import org.sonar.api.batch.sensor.error.AnalysisError;
import org.sonar.api.batch.sensor.error.NewAnalysisError;
import org.sonar.api.batch.sensor.highlighting.TypeOfText;
import org.sonar.api.batch.sensor.internal.SensorContextTester;
import org.sonar.api.batch.sensor.issue.NewIssue;
import org.sonar.api.batch.sensor.symbol.NewSymbolTable;
import org.sonar.api.config.MapSettings;
import org.sonar.api.config.Settings;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.utils.SonarException;

public class SensorContextTesterTest {
    @Rule
    public TemporaryFolder temp = new TemporaryFolder();
    @Rule
    public ExpectedException exception = ExpectedException.none();
    private SensorContextTester tester;
    private File baseDir;

    @Before
    public void prepare() throws Exception {
        this.baseDir = this.temp.newFolder();
        this.tester = SensorContextTester.create((File)this.baseDir);
    }

    @Test
    public void testSettings() {
        MapSettings settings = new MapSettings();
        settings.setProperty("foo", "bar");
        this.tester.setSettings((Settings)settings);
        Assertions.assertThat((String)this.tester.settings().getString("foo")).isEqualTo((Object)"bar");
    }

    @Test
    public void testActiveRules() {
        ActiveRules activeRules = new ActiveRulesBuilder().create(RuleKey.of((String)"repo", (String)"rule")).activate().build();
        this.tester.setActiveRules(activeRules);
        Assertions.assertThat((Iterable)this.tester.activeRules().findAll()).hasSize(1);
    }

    @Test
    public void testFs() throws Exception {
        DefaultFileSystem fs = new DefaultFileSystem(this.temp.newFolder());
        this.tester.setFileSystem(fs);
        Assertions.assertThat((File)this.tester.fileSystem().baseDir()).isNotEqualTo((Object)this.baseDir);
    }

    @Test
    public void testIssues() {
        Assertions.assertThat((Iterable)this.tester.allIssues()).isEmpty();
        NewIssue newIssue = this.tester.newIssue();
        newIssue.at(newIssue.newLocation().on((InputComponent)new TestInputFileBuilder("foo", "src/Foo.java").build())).forRule(RuleKey.of((String)"repo", (String)"rule")).save();
        newIssue = this.tester.newIssue();
        newIssue.at(newIssue.newLocation().on((InputComponent)new TestInputFileBuilder("foo", "src/Foo.java").build())).forRule(RuleKey.of((String)"repo", (String)"rule")).save();
        Assertions.assertThat((Iterable)this.tester.allIssues()).hasSize(2);
    }

    @Test
    public void testAnalysisErrors() {
        Assertions.assertThat((Iterable)this.tester.allAnalysisErrors()).isEmpty();
        NewAnalysisError newAnalysisError = this.tester.newAnalysisError();
        DefaultInputFile file = new TestInputFileBuilder("foo", "src/Foo.java").build();
        newAnalysisError.onFile((InputFile)file).message("error").at((TextPointer)new DefaultTextPointer(5, 2)).save();
        Assertions.assertThat((Iterable)this.tester.allAnalysisErrors()).hasSize(1);
        AnalysisError analysisError = (AnalysisError)this.tester.allAnalysisErrors().iterator().next();
        Assertions.assertThat((Object)analysisError.inputFile()).isEqualTo((Object)file);
        Assertions.assertThat((String)analysisError.message()).isEqualTo((Object)"error");
        Assertions.assertThat((Comparable)analysisError.location()).isEqualTo((Object)new DefaultTextPointer(5, 2));
    }

    @Test
    public void testMeasures() {
        Assertions.assertThat((Iterable)this.tester.measures("foo:src/Foo.java")).isEmpty();
        Assertions.assertThat((Object)this.tester.measure("foo:src/Foo.java", "ncloc")).isNull();
        this.tester.newMeasure().on((InputComponent)new TestInputFileBuilder("foo", "src/Foo.java").build()).forMetric((Metric)CoreMetrics.NCLOC).withValue((Serializable)Integer.valueOf(2)).save();
        Assertions.assertThat((Iterable)this.tester.measures("foo:src/Foo.java")).hasSize(1);
        Assertions.assertThat((Object)this.tester.measure("foo:src/Foo.java", "ncloc")).isNotNull();
        this.tester.newMeasure().on((InputComponent)new TestInputFileBuilder("foo", "src/Foo.java").build()).forMetric((Metric)CoreMetrics.LINES).withValue((Serializable)Integer.valueOf(4)).save();
        Assertions.assertThat((Iterable)this.tester.measures("foo:src/Foo.java")).hasSize(2);
        Assertions.assertThat((Object)this.tester.measure("foo:src/Foo.java", "ncloc")).isNotNull();
        Assertions.assertThat((Object)this.tester.measure("foo:src/Foo.java", "lines")).isNotNull();
        this.tester.newMeasure().on((InputComponent)new DefaultInputModule("foo")).forMetric((Metric)CoreMetrics.DIRECTORIES).withValue((Serializable)Integer.valueOf(4)).save();
        Assertions.assertThat((Iterable)this.tester.measures("foo")).hasSize(1);
        Assertions.assertThat((Object)this.tester.measure("foo", "directories")).isNotNull();
    }

    @Test(expected=SonarException.class)
    public void duplicateMeasures() {
        this.tester.newMeasure().on((InputComponent)new TestInputFileBuilder("foo", "src/Foo.java").build()).forMetric((Metric)CoreMetrics.NCLOC).withValue((Serializable)Integer.valueOf(2)).save();
        this.tester.newMeasure().on((InputComponent)new TestInputFileBuilder("foo", "src/Foo.java").build()).forMetric((Metric)CoreMetrics.NCLOC).withValue((Serializable)Integer.valueOf(2)).save();
    }

    @Test
    public void testHighlighting() {
        Assertions.assertThat((List)this.tester.highlightingTypeAt("foo:src/Foo.java", 1, 3)).isEmpty();
        this.tester.newHighlighting().onFile((InputFile)new TestInputFileBuilder("foo", "src/Foo.java").initMetadata("annot dsf fds foo bar").build()).highlight(1, 0, 1, 5, TypeOfText.ANNOTATION).highlight(8, 10, TypeOfText.CONSTANT).highlight(9, 10, TypeOfText.COMMENT).save();
        Assertions.assertThat((List)this.tester.highlightingTypeAt("foo:src/Foo.java", 1, 3)).containsExactly((Object[])new TypeOfText[]{TypeOfText.ANNOTATION});
        Assertions.assertThat((List)this.tester.highlightingTypeAt("foo:src/Foo.java", 1, 9)).containsExactly((Object[])new TypeOfText[]{TypeOfText.CONSTANT, TypeOfText.COMMENT});
    }

    @Test(expected=UnsupportedOperationException.class)
    public void duplicateHighlighting() {
        this.tester.newHighlighting().onFile((InputFile)new TestInputFileBuilder("foo", "src/Foo.java").initMetadata("annot dsf fds foo bar").build()).highlight(1, 0, 1, 5, TypeOfText.ANNOTATION).save();
        this.tester.newHighlighting().onFile((InputFile)new TestInputFileBuilder("foo", "src/Foo.java").initMetadata("annot dsf fds foo bar").build()).highlight(1, 0, 1, 5, TypeOfText.ANNOTATION).save();
    }

    @Test
    public void testSymbolReferences() {
        Assertions.assertThat((Iterable)this.tester.referencesForSymbolAt("foo:src/Foo.java", 1, 0)).isNull();
        NewSymbolTable symbolTable = this.tester.newSymbolTable().onFile((InputFile)new TestInputFileBuilder("foo", "src/Foo.java").initMetadata("annot dsf fds foo bar").build());
        symbolTable.newSymbol(1, 8, 1, 10);
        symbolTable.newSymbol(1, 1, 1, 5).newReference(6, 9).newReference(1, 10, 1, 13);
        symbolTable.save();
        Assertions.assertThat((Iterable)this.tester.referencesForSymbolAt("foo:src/Foo.java", 1, 0)).isNull();
        Assertions.assertThat((Iterable)this.tester.referencesForSymbolAt("foo:src/Foo.java", 1, 8)).isEmpty();
        Assertions.assertThat((Iterable)this.tester.referencesForSymbolAt("foo:src/Foo.java", 1, 3)).extracting(new String[]{"start.line", "start.lineOffset", "end.line", "end.lineOffset"}).containsExactly((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{1, 6, 1, 9}), Assertions.tuple((Object[])new Object[]{1, 10, 1, 13})});
    }

    @Test(expected=UnsupportedOperationException.class)
    public void duplicateSymbolReferences() {
        NewSymbolTable symbolTable = this.tester.newSymbolTable().onFile((InputFile)new TestInputFileBuilder("foo", "src/Foo.java").initMetadata("annot dsf fds foo bar").build());
        symbolTable.newSymbol(1, 8, 1, 10);
        symbolTable.save();
        symbolTable = this.tester.newSymbolTable().onFile((InputFile)new TestInputFileBuilder("foo", "src/Foo.java").initMetadata("annot dsf fds foo bar").build());
        symbolTable.newSymbol(1, 8, 1, 10);
        symbolTable.save();
    }

    @Test
    public void testCoverageAtLineZero() {
        Assertions.assertThat((Integer)this.tester.lineHits("foo:src/Foo.java", 1)).isNull();
        Assertions.assertThat((Integer)this.tester.lineHits("foo:src/Foo.java", 4)).isNull();
        this.exception.expect(IllegalStateException.class);
        this.tester.newCoverage().onFile((InputFile)new TestInputFileBuilder("foo", "src/Foo.java").initMetadata("annot dsf fds foo bar").build()).lineHits(0, 3);
    }

    @Test
    public void testCoverageAtLineOutOfRange() {
        Assertions.assertThat((Integer)this.tester.lineHits("foo:src/Foo.java", 1)).isNull();
        Assertions.assertThat((Integer)this.tester.lineHits("foo:src/Foo.java", 4)).isNull();
        this.exception.expect(IllegalStateException.class);
        this.tester.newCoverage().onFile((InputFile)new TestInputFileBuilder("foo", "src/Foo.java").initMetadata("annot dsf fds foo bar").build()).lineHits(4, 3);
    }

    @Test
    public void testLineHits() {
        Assertions.assertThat((Integer)this.tester.lineHits("foo:src/Foo.java", 1)).isNull();
        Assertions.assertThat((Integer)this.tester.lineHits("foo:src/Foo.java", 4)).isNull();
        this.tester.newCoverage().onFile((InputFile)new TestInputFileBuilder("foo", "src/Foo.java").initMetadata("annot dsf fds foo bar\nasdas").build()).lineHits(1, 2).lineHits(2, 3).save();
        Assertions.assertThat((Integer)this.tester.lineHits("foo:src/Foo.java", 1)).isEqualTo(2);
        Assertions.assertThat((Integer)this.tester.lineHits("foo:src/Foo.java", 2)).isEqualTo(3);
    }

    public void multipleCoverage() {
        this.tester.newCoverage().onFile((InputFile)new TestInputFileBuilder("foo", "src/Foo.java").initMetadata("annot dsf fds foo bar\nasdas").build()).lineHits(1, 2).conditions(3, 4, 2).save();
        this.tester.newCoverage().onFile((InputFile)new TestInputFileBuilder("foo", "src/Foo.java").initMetadata("annot dsf fds foo bar\nasdas").build()).lineHits(1, 2).conditions(3, 4, 3).save();
        Assertions.assertThat((Integer)this.tester.lineHits("foo:src/Foo.java", 1)).isEqualTo(4);
        Assertions.assertThat((Integer)this.tester.conditions("foo:src/Foo.java", 3)).isEqualTo(4);
        Assertions.assertThat((Integer)this.tester.coveredConditions("foo:src/Foo.java", 3)).isEqualTo(3);
    }

    @Test
    public void testConditions() {
        Assertions.assertThat((Integer)this.tester.conditions("foo:src/Foo.java", 1)).isNull();
        Assertions.assertThat((Integer)this.tester.coveredConditions("foo:src/Foo.java", 1)).isNull();
        this.tester.newCoverage().onFile((InputFile)new TestInputFileBuilder("foo", "src/Foo.java").initMetadata("annot dsf fds foo bar\nasd\nasdas\nasdfas").build()).conditions(1, 4, 2).save();
        Assertions.assertThat((Integer)this.tester.conditions("foo:src/Foo.java", 1)).isEqualTo(4);
        Assertions.assertThat((Integer)this.tester.coveredConditions("foo:src/Foo.java", 1)).isEqualTo(2);
    }

    @Test
    public void testCpdTokens() {
        Assertions.assertThat((List)this.tester.cpdTokens("foo:src/Foo.java")).isNull();
        DefaultInputFile inputFile = new TestInputFileBuilder("foo", "src/Foo.java").initMetadata("public class Foo {\n\n}").build();
        this.tester.newCpdTokens().onFile((InputFile)inputFile).addToken(inputFile.newRange(0, 6), "public").addToken(inputFile.newRange(7, 12), "class").addToken(inputFile.newRange(13, 16), "$IDENTIFIER").addToken(inputFile.newRange(17, 18), "{").addToken(inputFile.newRange(3, 0, 3, 1), "}").save();
        Assertions.assertThat((List)this.tester.cpdTokens("foo:src/Foo.java")).extracting(new String[]{"value", "startLine", "startUnit", "endUnit"}).containsExactly((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{"publicclass$IDENTIFIER{", 1, 1, 4}), Assertions.tuple((Object[])new Object[]{"}", 3, 5, 5})});
    }

    @Test(expected=UnsupportedOperationException.class)
    public void duplicateCpdTokens() {
        DefaultInputFile inputFile = new TestInputFileBuilder("foo", "src/Foo.java").initMetadata("public class Foo {\n\n}").build();
        this.tester.newCpdTokens().onFile((InputFile)inputFile).addToken(inputFile.newRange(0, 6), "public").save();
        this.tester.newCpdTokens().onFile((InputFile)inputFile).addToken(inputFile.newRange(0, 6), "public").save();
    }

    @Test
    public void testCancellation() {
        Assertions.assertThat((boolean)this.tester.isCancelled()).isFalse();
        this.tester.setCancelled(true);
        Assertions.assertThat((boolean)this.tester.isCancelled()).isTrue();
    }

    @Test
    public void testContextProperties() {
        Assertions.assertThat((Map)this.tester.getContextProperties()).isEmpty();
        this.tester.addContextProperty("foo", "bar");
        Assertions.assertThat((Map)this.tester.getContextProperties()).containsOnly(new Map.Entry[]{MapEntry.entry((Object)"foo", (Object)"bar")});
    }
}

