/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.sensor.internal;

import java.util.Map;
import org.assertj.core.api.Assertions;
import org.assertj.core.data.MapEntry;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.sonar.api.batch.sensor.internal.InMemorySensorStorage;

public class InMemorySensorStorageTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    InMemorySensorStorage underTest = new InMemorySensorStorage();

    @Test
    public void test_storeProperty() {
        Assertions.assertThat((Map)this.underTest.contextProperties).isEmpty();
        this.underTest.storeProperty("foo", "bar");
        Assertions.assertThat((Map)this.underTest.contextProperties).containsOnly(new Map.Entry[]{MapEntry.entry((Object)"foo", (Object)"bar")});
    }

    @Test
    public void storeProperty_throws_IAE_if_key_is_null() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("Key of context property must not be null");
        this.underTest.storeProperty(null, "bar");
    }

    @Test
    public void storeProperty_throws_IAE_if_value_is_null() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("Value of context property must not be null");
        this.underTest.storeProperty("foo", null);
    }
}

