/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.sensor.highlighting.internal;

import java.util.Collection;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.TextPointer;
import org.sonar.api.batch.fs.TextRange;
import org.sonar.api.batch.fs.internal.DefaultTextPointer;
import org.sonar.api.batch.fs.internal.DefaultTextRange;
import org.sonar.api.batch.fs.internal.TestInputFileBuilder;
import org.sonar.api.batch.sensor.highlighting.TypeOfText;
import org.sonar.api.batch.sensor.highlighting.internal.DefaultHighlighting;
import org.sonar.api.batch.sensor.highlighting.internal.SyntaxHighlightingRule;
import org.sonar.api.batch.sensor.internal.SensorStorage;

public class DefaultHighlightingTest {
    private static final InputFile INPUT_FILE = new TestInputFileBuilder("foo", "src/Foo.java").setLines(2).setOriginalLineOffsets(new int[]{0, 50}).setLastValidOffset(100).build();
    private Collection<SyntaxHighlightingRule> highlightingRules;
    @Rule
    public ExpectedException throwable = ExpectedException.none();

    @Before
    public void setUpSampleRules() {
        DefaultHighlighting highlightingDataBuilder = new DefaultHighlighting((SensorStorage)Mockito.mock(SensorStorage.class)).onFile(INPUT_FILE).highlight(0, 10, TypeOfText.COMMENT).highlight(1, 10, 1, 12, TypeOfText.KEYWORD).highlight(24, 38, TypeOfText.KEYWORD).highlight(42, 50, TypeOfText.KEYWORD).highlight(24, 65, TypeOfText.CPP_DOC).highlight(12, 20, TypeOfText.COMMENT);
        highlightingDataBuilder.save();
        this.highlightingRules = highlightingDataBuilder.getSyntaxHighlightingRuleSet();
    }

    @Test
    public void should_register_highlighting_rule() {
        Assertions.assertThat(this.highlightingRules).hasSize(6);
    }

    private static TextRange rangeOf(int startLine, int startOffset, int endLine, int endOffset) {
        return new DefaultTextRange((TextPointer)new DefaultTextPointer(startLine, startOffset), (TextPointer)new DefaultTextPointer(endLine, endOffset));
    }

    @Test
    public void should_order_by_start_then_end_offset() {
        Assertions.assertThat(this.highlightingRules).extracting("range", TextRange.class).containsExactly((Object[])new TextRange[]{DefaultHighlightingTest.rangeOf(1, 0, 1, 10), DefaultHighlightingTest.rangeOf(1, 10, 1, 12), DefaultHighlightingTest.rangeOf(1, 12, 1, 20), DefaultHighlightingTest.rangeOf(1, 24, 2, 15), DefaultHighlightingTest.rangeOf(1, 24, 1, 38), DefaultHighlightingTest.rangeOf(1, 42, 2, 0)});
        Assertions.assertThat(this.highlightingRules).extracting("textType").containsExactly(new Object[]{TypeOfText.COMMENT, TypeOfText.KEYWORD, TypeOfText.COMMENT, TypeOfText.CPP_DOC, TypeOfText.KEYWORD, TypeOfText.KEYWORD});
    }

    @Test
    public void should_support_overlapping() {
        new DefaultHighlighting((SensorStorage)Mockito.mock(SensorStorage.class)).onFile(INPUT_FILE).highlight(0, 15, TypeOfText.KEYWORD).highlight(8, 12, TypeOfText.CPP_DOC).save();
    }

    @Test
    public void should_prevent_start_equal_end() {
        this.throwable.expect(IllegalArgumentException.class);
        this.throwable.expectMessage("Unable to highlight file");
        new DefaultHighlighting((SensorStorage)Mockito.mock(SensorStorage.class)).onFile(INPUT_FILE).highlight(10, 10, TypeOfText.KEYWORD).save();
    }

    @Test
    public void should_prevent_boudaries_overlapping() {
        this.throwable.expect(IllegalStateException.class);
        this.throwable.expectMessage("Cannot register highlighting rule for characters at Range[from [line=1, lineOffset=8] to [line=1, lineOffset=15]] as it overlaps at least one existing rule");
        new DefaultHighlighting((SensorStorage)Mockito.mock(SensorStorage.class)).onFile(INPUT_FILE).highlight(0, 10, TypeOfText.KEYWORD).highlight(8, 15, TypeOfText.KEYWORD).save();
    }
}

