/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.sensor.error.internal;

import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.TextPointer;
import org.sonar.api.batch.fs.internal.DefaultTextPointer;
import org.sonar.api.batch.fs.internal.TestInputFileBuilder;
import org.sonar.api.batch.sensor.error.AnalysisError;
import org.sonar.api.batch.sensor.error.NewAnalysisError;
import org.sonar.api.batch.sensor.error.internal.DefaultAnalysisError;
import org.sonar.api.batch.sensor.internal.SensorStorage;

public class DefaultAnalysisErrorTest {
    private InputFile inputFile;
    private SensorStorage storage;
    private TextPointer textPointer;
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @Before
    public void setUp() {
        this.inputFile = new TestInputFileBuilder("module1", "src/File.java").build();
        this.textPointer = new DefaultTextPointer(5, 2);
        this.storage = (SensorStorage)Mockito.mock(SensorStorage.class);
    }

    @Test
    public void test_analysis_error() {
        DefaultAnalysisError analysisError = new DefaultAnalysisError(this.storage);
        analysisError.onFile(this.inputFile).at(this.textPointer).message("msg");
        Assertions.assertThat((Comparable)analysisError.location()).isEqualTo((Object)this.textPointer);
        Assertions.assertThat((String)analysisError.message()).isEqualTo((Object)"msg");
        Assertions.assertThat((Object)analysisError.inputFile()).isEqualTo((Object)this.inputFile);
    }

    @Test
    public void test_save() {
        DefaultAnalysisError analysisError = new DefaultAnalysisError(this.storage);
        analysisError.onFile(this.inputFile).save();
        ((SensorStorage)Mockito.verify((Object)this.storage)).store((AnalysisError)analysisError);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.storage});
    }

    @Test
    public void test_no_storage() {
        this.exception.expect(NullPointerException.class);
        DefaultAnalysisError analysisError = new DefaultAnalysisError();
        analysisError.onFile(this.inputFile).save();
    }

    @Test
    public void test_validation() {
        try {
            new DefaultAnalysisError(this.storage).onFile(null);
            Assert.fail((String)"Expected exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        NewAnalysisError error = new DefaultAnalysisError(this.storage).onFile(this.inputFile);
        try {
            error.onFile(this.inputFile);
            Assert.fail((String)"Expected exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        error = new DefaultAnalysisError(this.storage).at(this.textPointer);
        try {
            error.at(this.textPointer);
            Assert.fail((String)"Expected exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            new DefaultAnalysisError(this.storage).save();
            Assert.fail((String)"Expected exception");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }
}

