/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.sensor.cpd.internal;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.assertj.core.groups.Tuple;
import org.junit.Test;
import org.mockito.Mockito;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.internal.TestInputFileBuilder;
import org.sonar.api.batch.sensor.cpd.internal.DefaultCpdTokens;
import org.sonar.api.batch.sensor.internal.SensorStorage;
import org.sonar.api.config.MapSettings;
import org.sonar.api.config.Settings;

public class DefaultCpdTokensTest {
    private static final InputFile INPUT_FILE = new TestInputFileBuilder("foo", "src/Foo.java").setLines(2).setOriginalLineOffsets(new int[]{0, 50}).setLastValidOffset(100).build();

    @Test
    public void save_no_tokens() {
        SensorStorage sensorStorage = (SensorStorage)Mockito.mock(SensorStorage.class);
        DefaultCpdTokens tokens = new DefaultCpdTokens((Settings)new MapSettings(), sensorStorage).onFile(INPUT_FILE);
        tokens.save();
        ((SensorStorage)Mockito.verify((Object)sensorStorage)).store(tokens);
        Assertions.assertThat((Object)tokens.inputFile()).isEqualTo((Object)INPUT_FILE);
    }

    @Test
    public void save_one_token() {
        SensorStorage sensorStorage = (SensorStorage)Mockito.mock(SensorStorage.class);
        DefaultCpdTokens tokens = new DefaultCpdTokens((Settings)new MapSettings(), sensorStorage).onFile(INPUT_FILE).addToken(INPUT_FILE.newRange(1, 2, 1, 5), "foo");
        tokens.save();
        ((SensorStorage)Mockito.verify((Object)sensorStorage)).store(tokens);
        Assertions.assertThat((List)tokens.getTokenLines()).extracting(new String[]{"value", "startLine", "hashCode", "startUnit", "endUnit"}).containsExactly((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{"foo", 1, "foo".hashCode(), 1, 1})});
    }

    @Test
    public void handle_exclusions_by_pattern() {
        SensorStorage sensorStorage = (SensorStorage)Mockito.mock(SensorStorage.class);
        MapSettings settings = new MapSettings();
        settings.setProperty("sonar.cpd.exclusions", "src/Foo.java,another");
        DefaultCpdTokens tokens = new DefaultCpdTokens((Settings)settings, sensorStorage).onFile(INPUT_FILE).addToken(INPUT_FILE.newRange(1, 2, 1, 5), "foo");
        tokens.save();
        Mockito.verifyZeroInteractions((Object[])new Object[]{sensorStorage});
        Assertions.assertThat((List)tokens.getTokenLines()).isEmpty();
    }

    @Test
    public void save_many_tokens() {
        SensorStorage sensorStorage = (SensorStorage)Mockito.mock(SensorStorage.class);
        DefaultCpdTokens tokens = new DefaultCpdTokens((Settings)new MapSettings(), sensorStorage).onFile(INPUT_FILE).addToken(INPUT_FILE.newRange(1, 2, 1, 5), "foo").addToken(INPUT_FILE.newRange(1, 6, 1, 10), "bar").addToken(INPUT_FILE.newRange(1, 20, 1, 25), "biz").addToken(INPUT_FILE.newRange(2, 1, 2, 10), "next");
        tokens.save();
        ((SensorStorage)Mockito.verify((Object)sensorStorage)).store(tokens);
        Assertions.assertThat((List)tokens.getTokenLines()).extracting(new String[]{"value", "startLine", "hashCode", "startUnit", "endUnit"}).containsExactly((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{"foobarbiz", 1, "foobarbiz".hashCode(), 1, 3}), Assertions.tuple((Object[])new Object[]{"next", 2, "next".hashCode(), 4, 4})});
    }

    @Test
    public void basic_validation() {
        SensorStorage sensorStorage = (SensorStorage)Mockito.mock(SensorStorage.class);
        DefaultCpdTokens tokens = new DefaultCpdTokens((Settings)new MapSettings(), sensorStorage);
        try {
            tokens.save();
            Assertions.fail((String)"Expected exception");
        }
        catch (Exception e) {
            Assertions.assertThat((Throwable)e).hasMessage("Call onFile() first");
        }
        try {
            tokens.addToken(INPUT_FILE.newRange(1, 2, 1, 5), "foo");
            Assertions.fail((String)"Expected exception");
        }
        catch (Exception e) {
            Assertions.assertThat((Throwable)e).hasMessage("Call onFile() first");
        }
        try {
            tokens.addToken(null, "foo");
            Assertions.fail((String)"Expected exception");
        }
        catch (Exception e) {
            Assertions.assertThat((Throwable)e).hasMessage("Range should not be null");
        }
        try {
            tokens.addToken(INPUT_FILE.newRange(1, 2, 1, 5), null);
            Assertions.fail((String)"Expected exception");
        }
        catch (Exception e) {
            Assertions.assertThat((Throwable)e).hasMessage("Image should not be null");
        }
    }

    @Test
    public void validate_tokens_order() {
        SensorStorage sensorStorage = (SensorStorage)Mockito.mock(SensorStorage.class);
        DefaultCpdTokens tokens = new DefaultCpdTokens((Settings)new MapSettings(), sensorStorage).onFile(INPUT_FILE).addToken(INPUT_FILE.newRange(1, 6, 1, 10), "bar");
        try {
            tokens.addToken(INPUT_FILE.newRange(1, 2, 1, 5), "foo");
            Assertions.fail((String)"Expected exception");
        }
        catch (Exception e) {
            Assertions.assertThat((Throwable)e).hasMessage("Tokens of file [moduleKey=foo, relative=src/Foo.java, basedir=foo] should be provided in order.\nPrevious token: Range[from [line=1, lineOffset=6] to [line=1, lineOffset=10]]\nLast token: Range[from [line=1, lineOffset=2] to [line=1, lineOffset=5]]");
        }
    }
}

