/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.rule.internal;

import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.sonar.api.batch.rule.Rule;
import org.sonar.api.batch.rule.Rules;
import org.sonar.api.batch.rule.internal.NewRule;
import org.sonar.api.batch.rule.internal.RulesBuilder;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.rule.RuleStatus;
import org.sonar.api.rule.Severity;

public class RulesBuilderTest {
    @org.junit.Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void no_rules() {
        RulesBuilder builder = new RulesBuilder();
        Rules rules = builder.build();
        Assertions.assertThat((Iterable)rules.findAll()).isEmpty();
    }

    @Test
    public void build_rules() {
        RulesBuilder builder = new RulesBuilder();
        NewRule newSquid1 = builder.add(RuleKey.of((String)"squid", (String)"S0001"));
        newSquid1.setName("Detect bug");
        newSquid1.setDescription("Detect potential bug");
        newSquid1.setInternalKey("foo=bar");
        newSquid1.setSeverity("CRITICAL");
        newSquid1.setStatus(RuleStatus.BETA);
        newSquid1.addParam("min");
        newSquid1.addParam("max").setDescription("Maximum");
        builder.add(RuleKey.of((String)"squid", (String)"S0002"));
        builder.add(RuleKey.of((String)"findbugs", (String)"NPE"));
        Rules rules = builder.build();
        Assertions.assertThat((Iterable)rules.findAll()).hasSize(3);
        Assertions.assertThat((Iterable)rules.findByRepository("squid")).hasSize(2);
        Assertions.assertThat((Iterable)rules.findByRepository("findbugs")).hasSize(1);
        Assertions.assertThat((Iterable)rules.findByRepository("unknown")).isEmpty();
        Rule squid1 = rules.find(RuleKey.of((String)"squid", (String)"S0001"));
        Assertions.assertThat((String)squid1.key().repository()).isEqualTo((Object)"squid");
        Assertions.assertThat((String)squid1.key().rule()).isEqualTo((Object)"S0001");
        Assertions.assertThat((String)squid1.name()).isEqualTo((Object)"Detect bug");
        Assertions.assertThat((String)squid1.description()).isEqualTo((Object)"Detect potential bug");
        Assertions.assertThat((String)squid1.internalKey()).isEqualTo((Object)"foo=bar");
        Assertions.assertThat((Comparable)squid1.status()).isEqualTo((Object)RuleStatus.BETA);
        Assertions.assertThat((String)squid1.severity()).isEqualTo((Object)"CRITICAL");
        Assertions.assertThat((Iterable)squid1.params()).hasSize(2);
        Assertions.assertThat((String)squid1.param("min").key()).isEqualTo((Object)"min");
        Assertions.assertThat((String)squid1.param("min").description()).isNull();
        Assertions.assertThat((String)squid1.param("max").key()).isEqualTo((Object)"max");
        Assertions.assertThat((String)squid1.param("max").description()).isEqualTo((Object)"Maximum");
        Rule squid2 = rules.find(RuleKey.of((String)"squid", (String)"S0002"));
        Assertions.assertThat((String)squid2.key().repository()).isEqualTo((Object)"squid");
        Assertions.assertThat((String)squid2.key().rule()).isEqualTo((Object)"S0002");
        Assertions.assertThat((String)squid2.description()).isNull();
        Assertions.assertThat((String)squid2.internalKey()).isNull();
        Assertions.assertThat((Comparable)squid2.status()).isEqualTo((Object)RuleStatus.defaultStatus());
        Assertions.assertThat((String)squid2.severity()).isEqualTo((Object)Severity.defaultSeverity());
        Assertions.assertThat((Iterable)squid2.params()).isEmpty();
    }

    @Test
    public void fail_to_add_twice_the_same_rule() {
        RulesBuilder builder = new RulesBuilder();
        builder.add(RuleKey.of((String)"squid", (String)"S0001"));
        this.thrown.expect(IllegalStateException.class);
        this.thrown.expectMessage("Rule 'squid:S0001' already exists");
        builder.add(RuleKey.of((String)"squid", (String)"S0001"));
    }

    @Test
    public void fail_to_add_twice_the_same_param() {
        RulesBuilder builder = new RulesBuilder();
        NewRule newRule = builder.add(RuleKey.of((String)"squid", (String)"S0001"));
        newRule.addParam("min");
        newRule.addParam("max");
        this.thrown.expect(IllegalStateException.class);
        this.thrown.expectMessage("Parameter 'min' already exists on rule 'squid:S0001'");
        newRule.addParam("min");
    }
}

